<?php
session_start();
require_once __DIR__ . '/../config/config.php';
require_once __DIR__ . '/../app/models/Search.php';

// Check if user is logged in
if (!isset($_SESSION['user_id']) || $_SESSION['role'] !== 'user') {
    header('Location: login.php');
    exit;
}

$searchModel = new Search();
$searches = $searchModel->getUserSearches($_SESSION['user_id'], 100);
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Search History - <?php echo SITE_NAME; ?></title>
    <link rel="stylesheet" href="assets/css/style.css">
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@300;400;500;600;700;800&display=swap" rel="stylesheet">
    <link href="https://unpkg.com/aos@2.3.1/dist/aos.css" rel="stylesheet">
</head>
<body>
    <?php include 'includes/user-navbar.php'; ?>

    <div class="container mt-4">
        <h2 class="gradient-text mb-4" data-aos="fade-up">Search History</h2>

        <?php if (count($searches) > 0): ?>
            <div class="table-responsive" data-aos="fade-up">
                <table>
                    <thead>
                        <tr>
                            <th>#</th>
                            <th>Type</th>
                            <th>Query</th>
                            <th>Source</th>
                            <th>Date & Time</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php foreach ($searches as $index => $search): ?>
                            <tr>
                                <td><?php echo $index + 1; ?></td>
                                <td>
                                    <span class="badge badge-info">
                                        <?php echo strtoupper($search['search_type']); ?>
                                    </span>
                                </td>
                                <td><?php echo htmlspecialchars($search['query_value']); ?></td>
                                <td>
                                    <span class="badge <?php echo $search['source'] === 'cache' ? 'badge-success' : 'badge-warning'; ?>">
                                        <?php echo strtoupper($search['source']); ?>
                                    </span>
                                </td>
                                <td><?php echo date('d M Y, h:i A', strtotime($search['created_at'])); ?></td>
                            </tr>
                        <?php endforeach; ?>
                    </tbody>
                </table>
            </div>
        <?php else: ?>
            <div class="glass-card text-center" data-aos="fade-up">
                <div style="font-size: 64px; margin-bottom: 20px;">📭</div>
                <h3>No Search History</h3>
                <p style="opacity: 0.7;">You haven't performed any searches yet.</p>
                <a href="search.php?type=mobile" class="btn btn-primary mt-3">Start Searching</a>
            </div>
        <?php endif; ?>
    </div>

    <!-- Footer -->
    <footer class="footer">
        <div class="container">
            <p>&copy; <?php echo date('Y'); ?> <?php echo SITE_NAME; ?>. All rights reserved.</p>
        </div>
    </footer>

    <script src="https://unpkg.com/aos@2.3.1/dist/aos.js"></script>
    <script>
        AOS.init({
            duration: 1000,
            once: true
        });
    </script>
    
    <?php include 'includes/chat-widget.php'; ?>
</body>
</html>
