<!-- Social Proof Section -->
<section class="social-proof-section" style="padding: 80px 0; background: linear-gradient(135deg, rgba(102, 126, 234, 0.05) 0%, rgba(118, 75, 162, 0.05) 100%);">
    <div class="container">
        <!-- Stats Counter -->
        <div class="row mb-5" data-aos="fade-up">
            <div class="col-md-3 col-6 mb-4">
                <div class="stat-box text-center">
                    <div class="stat-number gradient-text" data-count="10000">0</div>
                    <p class="stat-label">Happy Users</p>
                </div>
            </div>
            <div class="col-md-3 col-6 mb-4">
                <div class="stat-box text-center">
                    <div class="stat-number gradient-text" data-count="50000">0</div>
                    <p class="stat-label">Searches Completed</p>
                </div>
            </div>
            <div class="col-md-3 col-6 mb-4">
                <div class="stat-box text-center">
                    <div class="stat-number gradient-text" data-count="99" data-suffix="%">0</div>
                    <p class="stat-label">Accuracy</p>
                </div>
            </div>
            <div class="col-md-3 col-6 mb-4">
                <div class="stat-box text-center">
                    <div class="stat-number gradient-text">24/7</div>
                    <p class="stat-label">Support</p>
                </div>
            </div>
        </div>

        <!-- Testimonials -->
        <h2 class="text-center gradient-text mb-5" data-aos="fade-up">What Our Users Say</h2>
        <div class="row">
            <div class="col-md-4 mb-4" data-aos="fade-up" data-aos-delay="100">
                <div class="testimonial-card glass-card" style="padding: 30px; height: 100%;">
                    <div style="display: flex; gap: 10px; margin-bottom: 15px; color: #ffc107; font-size: 20px;">
                        ⭐⭐⭐⭐⭐
                    </div>
                    <p style="font-style: italic; margin-bottom: 20px; line-height: 1.6;">
                        "Gravity has been a game-changer for our business. The accuracy and speed of searches are incredible. Highly recommended!"
                    </p>
                    <div style="display: flex; align-items: center; gap: 15px;">
                        <div style="width: 50px; height: 50px; border-radius: 50%; background: var(--primary-gradient); display: flex; align-items: center; justify-content: center; font-size: 24px; font-weight: 700;">
                            R
                        </div>
                        <div>
                            <strong>Rahul Sharma</strong>
                            <p style="margin: 0; opacity: 0.7; font-size: 14px;">Business Owner</p>
                        </div>
                    </div>
                </div>
            </div>

            <div class="col-md-4 mb-4" data-aos="fade-up" data-aos-delay="200">
                <div class="testimonial-card glass-card" style="padding: 30px; height: 100%;">
                    <div style="display: flex; gap: 10px; margin-bottom: 15px; color: #ffc107; font-size: 20px;">
                        ⭐⭐⭐⭐⭐
                    </div>
                    <p style="font-style: italic; margin-bottom: 20px; line-height: 1.6;">
                        "Best platform for mobile and Aadhaar verification. The AI chatbot is super helpful and the interface is beautiful!"
                    </p>
                    <div style="display: flex; align-items: center; gap: 15px;">
                        <div style="width: 50px; height: 50px; border-radius: 50%; background: var(--primary-gradient); display: flex; align-items: center; justify-content: center; font-size: 24px; font-weight: 700;">
                            P
                        </div>
                        <div>
                            <strong>Priya Patel</strong>
                            <p style="margin: 0; opacity: 0.7; font-size: 14px;">Freelancer</p>
                        </div>
                    </div>
                </div>
            </div>

            <div class="col-md-4 mb-4" data-aos="fade-up" data-aos-delay="300">
                <div class="testimonial-card glass-card" style="padding: 30px; height: 100%;">
                    <div style="display: flex; gap: 10px; margin-bottom: 15px; color: #ffc107; font-size: 20px;">
                        ⭐⭐⭐⭐⭐
                    </div>
                    <p style="font-style: italic; margin-bottom: 20px; line-height: 1.6;">
                        "Fast, reliable, and affordable. The subscription plans are perfect for our needs. Great customer support too!"
                    </p>
                    <div style="display: flex; align-items: center; gap: 15px;">
                        <div style="width: 50px; height: 50px; border-radius: 50%; background: var(--primary-gradient); display: flex; align-items: center; justify-content: center; font-size: 24px; font-weight: 700;">
                            A
                        </div>
                        <div>
                            <strong>Amit Kumar</strong>
                            <p style="margin: 0; opacity: 0.7; font-size: 14px;">IT Professional</p>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!-- Trust Badges -->
        <div class="trust-badges mt-5" data-aos="fade-up">
            <h3 class="text-center mb-5" style="color: white; font-size: 32px; font-weight: 700;">Trusted & Secure</h3>
            <div class="row justify-content-center" style="gap: 20px 0;">
                <div class="col-lg-2 col-md-4 col-6 mb-4">
                    <div class="trust-badge glass-card text-center" style="padding: 30px 20px; min-height: 180px; display: flex; flex-direction: column; justify-content: center; margin: 0 10px;">
                        <div style="font-size: 48px; margin-bottom: 15px;">🔒</div>
                        <strong style="font-size: 16px; display: block; margin-bottom: 8px;">SSL Secured</strong>
                        <p style="margin: 0; opacity: 0.7; font-size: 13px;">256-bit Encryption</p>
                    </div>
                </div>
                <div class="col-lg-2 col-md-4 col-6 mb-4">
                    <div class="trust-badge glass-card text-center" style="padding: 30px 20px; min-height: 180px; display: flex; flex-direction: column; justify-content: center; margin: 0 10px;">
                        <div style="font-size: 48px; margin-bottom: 15px;">⚡</div>
                        <strong style="font-size: 16px; display: block; margin-bottom: 8px;">Fast & Reliable</strong>
                        <p style="margin: 0; opacity: 0.7; font-size: 13px;">99.9% Uptime</p>
                    </div>
                </div>
                <div class="col-lg-2 col-md-4 col-6 mb-4">
                    <div class="trust-badge glass-card text-center" style="padding: 30px 20px; min-height: 180px; display: flex; flex-direction: column; justify-content: center; margin: 0 10px;">
                        <div style="font-size: 48px; margin-bottom: 15px;">🎯</div>
                        <strong style="font-size: 16px; display: block; margin-bottom: 8px;">Accurate Data</strong>
                        <p style="margin: 0; opacity: 0.7; font-size: 13px;">Verified Sources</p>
                    </div>
                </div>
                <div class="col-lg-2 col-md-4 col-6 mb-4">
                    <div class="trust-badge glass-card text-center" style="padding: 30px 20px; min-height: 180px; display: flex; flex-direction: column; justify-content: center; margin: 0 10px;">
                        <div style="font-size: 48px; margin-bottom: 15px;">💬</div>
                        <strong style="font-size: 16px; display: block; margin-bottom: 8px;">24/7 Support</strong>
                        <p style="margin: 0; opacity: 0.7; font-size: 13px;">Always Here</p>
                    </div>
                </div>
                <div class="col-lg-2 col-md-4 col-6 mb-4">
                    <div class="trust-badge glass-card text-center" style="padding: 30px 20px; min-height: 180px; display: flex; flex-direction: column; justify-content: center; margin: 0 10px;">
                        <div style="font-size: 48px; margin-bottom: 15px;">🤖</div>
                        <strong style="font-size: 16px; display: block; margin-bottom: 8px;">AI-Powered</strong>
                        <p style="margin: 0; opacity: 0.7; font-size: 13px;">Smart Search</p>
                    </div>
                </div>
                <div class="col-lg-2 col-md-4 col-6 mb-4">
                    <div class="trust-badge glass-card text-center" style="padding: 30px 20px; min-height: 180px; display: flex; flex-direction: column; justify-content: center; margin: 0 10px;">
                        <div style="font-size: 48px; margin-bottom: 15px;">🛡️</div>
                        <strong style="font-size: 16px; display: block; margin-bottom: 8px;">Privacy First</strong>
                        <p style="margin: 0; opacity: 0.7; font-size: 13px;">Data Protected</p>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>

<style>
.stat-box {
    padding: 20px;
}

.stat-number {
    font-size: 48px;
    font-weight: 800;
    margin-bottom: 10px;
}

.stat-label {
    opacity: 0.8;
    font-size: 14px;
    margin: 0;
}

.testimonial-card {
    transition: transform 0.3s ease, box-shadow 0.3s ease;
}

.testimonial-card:hover {
    transform: translateY(-5px);
    box-shadow: 0 10px 40px rgba(102, 126, 234, 0.3);
}

.trust-badge {
    transition: transform 0.3s ease;
}

.trust-badge:hover {
    transform: scale(1.05);
}

@media (max-width: 768px) {
    .stat-number {
        font-size: 36px;
    }
    
    .stat-label {
        font-size: 12px;
    }
}
</style>

<script>
// Animated Counter
function animateCounter() {
    const counters = document.querySelectorAll('[data-count]');
    
    counters.forEach(counter => {
        const target = parseInt(counter.getAttribute('data-count'));
        const suffix = counter.getAttribute('data-suffix') || '';
        const duration = 2000; // 2 seconds
        const increment = target / (duration / 16); // 60fps
        let current = 0;
        
        const updateCounter = () => {
            current += increment;
            if (current < target) {
                counter.textContent = Math.floor(current).toLocaleString() + suffix;
                requestAnimationFrame(updateCounter);
            } else {
                counter.textContent = target.toLocaleString() + suffix;
            }
        };
        
        // Start animation when element is in viewport
        const observer = new IntersectionObserver((entries) => {
            entries.forEach(entry => {
                if (entry.isIntersecting) {
                    updateCounter();
                    observer.unobserve(entry.target);
                }
            });
        });
        
        observer.observe(counter);
    });
}

// Initialize on page load
if (document.readyState === 'loading') {
    document.addEventListener('DOMContentLoaded', animateCounter);
} else {
    animateCounter();
}
</script>
