<!-- Modern User Navigation Bar -->
<nav class="user-navbar">
    <div class="container">
        <a href="dashboard.php" class="navbar-brand">
            <span class="brand-icon">⚡</span>
            <span class="brand-text">Gravity</span>
        </a>
        
        <button class="navbar-toggle" onclick="toggleMobileMenu()">
            <span></span>
            <span></span>
            <span></span>
        </button>
        
        <ul class="navbar-menu" id="navbarMenu">
            <li><a href="dashboard.php" class="nav-link <?php echo basename($_SERVER['PHP_SELF']) == 'dashboard.php' ? 'active' : ''; ?>">
                <span class="nav-icon">🏠</span>
                <span class="nav-text">Dashboard</span>
            </a></li>
            
            <li><a href="search.php?type=mobile" class="nav-link <?php echo (basename($_SERVER['PHP_SELF']) == 'search.php' && isset($_GET['type']) && $_GET['type'] == 'mobile') ? 'active' : ''; ?>">
                <span class="nav-icon">📲</span>
                <span class="nav-text">Mobile Search</span>
            </a></li>
            
            <li><a href="search.php?type=aadhaar" class="nav-link <?php echo (basename($_SERVER['PHP_SELF']) == 'search.php' && isset($_GET['type']) && $_GET['type'] == 'aadhaar') ? 'active' : ''; ?>">
                <span class="nav-icon">🎫</span>
                <span class="nav-text">Aadhaar Search</span>
            </a></li>
            
            <li><a href="history.php" class="nav-link <?php echo basename($_SERVER['PHP_SELF']) == 'history.php' ? 'active' : ''; ?>">
                <span class="nav-icon">📋</span>
                <span class="nav-text">History</span>
            </a></li>
            
            <li><a href="plans.php" class="nav-link <?php echo basename($_SERVER['PHP_SELF']) == 'plans.php' ? 'active' : ''; ?>">
                <span class="nav-icon">⭐</span>
                <span class="nav-text">Plans</span>
            </a></li>
            
            <li><a href="notifications.php" class="nav-link <?php echo basename($_SERVER['PHP_SELF']) == 'notifications.php' ? 'active' : ''; ?>">
                <span class="nav-icon">🔔</span>
                <span class="nav-text">Notifications</span>
                <?php if (isset($_SESSION['unread_notifications']) && $_SESSION['unread_notifications'] > 0): ?>
                    <span class="notification-badge"><?php echo $_SESSION['unread_notifications']; ?></span>
                <?php endif; ?>
            </a></li>
            
            <li><a href="profile.php" class="nav-link <?php echo basename($_SERVER['PHP_SELF']) == 'profile.php' ? 'active' : ''; ?>">
                <span class="nav-icon">👨‍💼</span>
                <span class="nav-text">Profile</span>
            </a></li>
            
            <li><a href="activity-log.php" class="nav-link <?php echo basename($_SERVER['PHP_SELF']) == 'activity-log.php' ? 'active' : ''; ?>">
                <span class="nav-icon">📝</span>
                <span class="nav-text">Activity Log</span>
            </a></li>
            
            <li><a href="logout.php" class="nav-link logout-link">
                <span class="nav-icon">🚀</span>
                <span class="nav-text">Logout</span>
            </a></li>
        </ul>
    </div>
</nav>

<style>
.user-navbar {
    background: var(--glass-bg);
    backdrop-filter: blur(20px);
    border-bottom: 1px solid var(--glass-border);
    padding: 0;
    position: sticky;
    top: 0;
    z-index: 1000;
    box-shadow: 0 4px 20px rgba(0, 0, 0, 0.1);
}

.user-navbar .container {
    display: flex;
    justify-content: space-between;
    align-items: center;
    padding: 0 20px;
    max-width: 1400px;
    margin: 0 auto;
}

.user-navbar .navbar-brand {
    display: flex;
    align-items: center;
    gap: 10px;
    text-decoration: none;
    padding: 15px 0;
    font-size: 24px;
    font-weight: 700;
    transition: all 0.3s ease;
}

.user-navbar .brand-icon {
    font-size: 28px;
    animation: pulse 2s ease-in-out infinite;
}

@keyframes pulse {
    0%, 100% { transform: scale(1); }
    50% { transform: scale(1.1); }
}

.user-navbar .brand-text {
    background: var(--primary-gradient);
    -webkit-background-clip: text;
    -webkit-text-fill-color: transparent;
    background-clip: text;
}

.navbar-toggle {
    display: none;
    flex-direction: column;
    gap: 5px;
    background: none;
    border: none;
    cursor: pointer;
    padding: 10px;
}

.navbar-toggle span {
    width: 25px;
    height: 3px;
    background: var(--text-light);
    border-radius: 2px;
    transition: all 0.3s ease;
}

.navbar-menu {
    display: flex;
    list-style: none;
    margin: 0;
    padding: 0;
    gap: 2px;
    align-items: center;
}

.navbar-menu li {
    position: relative;
}

.nav-link {
    display: flex;
    align-items: center;
    gap: 6px;
    padding: 10px 12px;
    text-decoration: none;
    color: var(--text-light);
    border-radius: 10px;
    transition: all 0.3s ease;
    font-size: 13px;
    font-weight: 500;
    position: relative;
    overflow: hidden;
}

.nav-link::before {
    content: '';
    position: absolute;
    top: 0;
    left: 0;
    width: 100%;
    height: 100%;
    background: linear-gradient(135deg, rgba(102, 126, 234, 0.1), rgba(118, 75, 162, 0.1));
    opacity: 0;
    transition: opacity 0.3s ease;
    z-index: -1;
}

.nav-link:hover::before,
.nav-link.active::before {
    opacity: 1;
}

.nav-link:hover {
    transform: translateY(-2px);
    color: var(--neon-blue);
}

.nav-link.active {
    background: linear-gradient(135deg, rgba(102, 126, 234, 0.2), rgba(118, 75, 162, 0.2));
    border: 1px solid rgba(102, 126, 234, 0.3);
    color: var(--neon-blue);
}

.nav-icon {
    font-size: 18px;
    line-height: 1;
}

.nav-text {
    white-space: nowrap;
}

.notification-badge {
    position: absolute;
    top: 8px;
    right: 8px;
    background: #f5576c;
    color: white;
    font-size: 10px;
    font-weight: bold;
    padding: 2px 6px;
    border-radius: 10px;
    min-width: 18px;
    text-align: center;
    animation: bounce 1s ease-in-out infinite;
}

@keyframes bounce {
    0%, 100% { transform: translateY(0); }
    50% { transform: translateY(-3px); }
}

.logout-link {
    background: linear-gradient(135deg, rgba(245, 87, 108, 0.1), rgba(220, 38, 38, 0.1));
    border: 1px solid rgba(245, 87, 108, 0.2);
}

.logout-link:hover {
    background: linear-gradient(135deg, rgba(245, 87, 108, 0.2), rgba(220, 38, 38, 0.2));
    border-color: rgba(245, 87, 108, 0.4);
    color: #f5576c;
}

/* Mobile Responsive */
@media (max-width: 1024px) {
    .navbar-toggle {
        display: flex;
    }
    
    .navbar-menu {
        position: fixed;
        top: 70px;
        right: -100%;
        width: 280px;
        height: calc(100vh - 70px);
        background: var(--glass-bg);
        backdrop-filter: blur(20px);
        border-left: 1px solid var(--glass-border);
        flex-direction: column;
        padding: 20px;
        gap: 10px;
        transition: right 0.3s ease;
        overflow-y: auto;
        box-shadow: -4px 0 20px rgba(0, 0, 0, 0.2);
    }
    
    .navbar-menu.active {
        right: 0;
    }
    
    .navbar-menu li {
        width: 100%;
    }
    
    .nav-link {
        width: 100%;
        justify-content: flex-start;
        padding: 15px 20px;
    }
    
    .nav-icon {
        font-size: 20px;
    }
    
    .nav-text {
        font-size: 16px;
    }
}

@media (max-width: 768px) {
    .user-navbar .brand-text {
        display: none;
    }
    
    .navbar-menu {
        width: 100%;
        right: -100%;
    }
}
</style>

<script>
function toggleMobileMenu() {
    const menu = document.getElementById('navbarMenu');
    menu.classList.toggle('active');
}

// Close menu when clicking outside
document.addEventListener('click', function(event) {
    const navbar = document.querySelector('.user-navbar');
    const menu = document.getElementById('navbarMenu');
    const toggle = document.querySelector('.navbar-toggle');
    
    if (!navbar.contains(event.target) && menu.classList.contains('active')) {
        menu.classList.remove('active');
    }
});

// Close menu when clicking on a link
document.querySelectorAll('.nav-link').forEach(link => {
    link.addEventListener('click', function() {
        const menu = document.getElementById('navbarMenu');
        menu.classList.remove('active');
    });
});
</script>
