<?php
require_once __DIR__ . '/../config/config.php';
?>
<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?php echo SITE_NAME; ?> - Intelligence at Your Fingertips</title>
    <meta name="description"
        content="Gravity - Advanced Mobile & Aadhaar Intelligence Platform with AI-powered search capabilities">
    <link rel="stylesheet" href="assets/css/style.css">
    <link rel="stylesheet" href="assets/css/premium-landing.css">
    <link
        href="https://fonts.googleapis.com/css2?family=Inter:wght@300;400;500;600;700;800;900&family=Outfit:wght@300;400;500;600;700;800;900&display=swap"
        rel="stylesheet">
    <link href="https://unpkg.com/aos@2.3.1/dist/aos.css" rel="stylesheet">
</head>

<body>
    <!-- Animated Particles Background -->
    <div class="particles-container" id="particles"></div>

    <!-- Navigation -->
    <nav class="navbar-premium">
        <div class="container">
            <a href="index.php" class="navbar-brand-premium">
                <span class="brand-text">Gravity</span>
            </a>
            <ul class="navbar-menu-premium">
                <li><a href="#features" class="nav-link-premium">Features</a></li>
                <li><a href="#plans" class="nav-link-premium">Pricing</a></li>
                <li><a href="#testimonials" class="nav-link-premium">Reviews</a></li>
                <li><a href="login.php" class="btn btn-outline-premium">Login</a></li>
                <li><a href="register.php" class="btn btn-primary-premium">Get Started Free</a></li>
            </ul>
        </div>
    </nav>

    <!-- Hero Section -->
    <section class="hero-premium">
        <div class="hero-gradient-orb orb-1"></div>
        <div class="hero-gradient-orb orb-2"></div>
        <div class="hero-gradient-orb orb-3"></div>

        <div class="container">
            <div class="hero-badge" data-aos="fade-down">
                <span class="badge-dot"></span>
                AI-Powered Intelligence Platform
            </div>

            <h1 class="hero-title" data-aos="fade-up" data-aos-delay="100">
                <span class="title-line">Unlock the Power of</span>
                <span class="title-gradient" id="typewriter"></span>
                <span class="cursor-premium">|</span>
            </h1>

            <p class="hero-description" data-aos="fade-up" data-aos-delay="200">
                Experience lightning-fast mobile & Aadhaar intelligence with our cutting-edge AI platform.<br>
                <span class="highlight-text">Start with 10 FREE searches - No credit card required!</span>
            </p>

            <div class="hero-cta" data-aos="fade-up" data-aos-delay="300">
                <a href="register.php" class="btn-hero-primary">
                    <span class="btn-icon">🚀</span>
                    Start Free Trial
                    <span class="btn-shine"></span>
                </a>
                <a href="#plans" class="btn-hero-secondary">
                    <span class="btn-icon">💎</span>
                    View Pricing
                </a>
            </div>

            <div class="hero-stats" data-aos="fade-up" data-aos-delay="400">
                <div class="stat-item">
                    <div class="stat-value">10K+</div>
                    <div class="stat-label">Active Users</div>
                </div>
                <div class="stat-divider"></div>
                <div class="stat-item">
                    <div class="stat-value">1M+</div>
                    <div class="stat-label">Searches</div>
                </div>
                <div class="stat-divider"></div>
                <div class="stat-item">
                    <div class="stat-value">99.9%</div>
                    <div class="stat-label">Uptime</div>
                </div>
            </div>
        </div>
    </section>

    <!-- Features Section -->
    <section id="features" class="features-premium">
        <div class="container">
            <div class="section-header" data-aos="fade-up">
                <span class="section-tag">Features</span>
                <h2 class="section-title">Why Choose Gravity?</h2>
                <p class="section-subtitle">Powerful features designed for modern intelligence needs</p>
            </div>

            <div class="features-grid">
                <div class="feature-card" data-aos="fade-up" data-aos-delay="100">
                    <div class="feature-icon icon-gradient-1">⚡</div>
                    <h3 class="feature-title">Lightning Fast</h3>
                    <p class="feature-description">Get instant results with our advanced caching system. Most queries
                        return in milliseconds.</p>
                    <div class="feature-hover-effect"></div>
                </div>

                <div class="feature-card" data-aos="fade-up" data-aos-delay="150">
                    <div class="feature-icon icon-gradient-2">🔒</div>
                    <h3 class="feature-title">Bank-Grade Security</h3>
                    <p class="feature-description">Your data is encrypted with 256-bit SSL and protected with
                        enterprise-grade security.</p>
                    <div class="feature-hover-effect"></div>
                </div>

                <div class="feature-card" data-aos="fade-up" data-aos-delay="200">
                    <div class="feature-icon icon-gradient-3">📊</div>
                    <h3 class="feature-title">99% Accuracy</h3>
                    <p class="feature-description">Access verified and up-to-date information from trusted and reliable
                        sources.</p>
                    <div class="feature-hover-effect"></div>
                </div>

                <div class="feature-card" data-aos="fade-up" data-aos-delay="250">
                    <div class="feature-icon icon-gradient-4">🤖</div>
                    <h3 class="feature-title">AI-Powered</h3>
                    <p class="feature-description">Smart search algorithms that learn and improve with every query you
                        make.</p>
                    <div class="feature-hover-effect"></div>
                </div>

                <div class="feature-card" data-aos="fade-up" data-aos-delay="300">
                    <div class="feature-icon icon-gradient-5">📱</div>
                    <h3 class="feature-title">Mobile First</h3>
                    <p class="feature-description">Seamlessly access from anywhere, anytime on any device with
                        responsive design.</p>
                    <div class="feature-hover-effect"></div>
                </div>

                <div class="feature-card" data-aos="fade-up" data-aos-delay="350">
                    <div class="feature-icon icon-gradient-6">💬</div>
                    <h3 class="feature-title">24/7 Support</h3>
                    <p class="feature-description">Our dedicated team is always here to help you succeed with instant
                        assistance.</p>
                    <div class="feature-hover-effect"></div>
                </div>
            </div>
        </div>
    </section>

    <!-- Pricing Section -->
    <section id="plans" class="pricing-premium">
        <div class="container">
            <div class="section-header" data-aos="fade-up">
                <span class="section-tag">Pricing</span>
                <h2 class="section-title">Choose Your Perfect Plan</h2>
                <p class="section-subtitle">Flexible pricing options designed for every need</p>
            </div>

            <div class="pricing-grid">
                <!-- Basic Plan -->
                <div class="pricing-card" data-aos="fade-up" data-aos-delay="100">
                    <div class="pricing-header">
                        <h3 class="plan-name">Basic</h3>
                        <p class="plan-description">Perfect for individuals</p>
                    </div>
                    <div class="pricing-price">
                        <span class="currency">₹</span>
                        <span class="amount">99</span>
                        <span class="period">/month</span>
                    </div>
                    <ul class="pricing-features">
                        <li><span class="check-icon">✓</span> 50 Searches/Month</li>
                        <li><span class="check-icon">✓</span> Mobile Lookup</li>
                        <li><span class="check-icon">✓</span> Aadhaar Lookup</li>
                        <li><span class="check-icon">✓</span> Email Support</li>
                        <li><span class="check-icon">✓</span> Search History</li>
                    </ul>
                    <a href="register.php" class="btn-pricing">Get Started</a>
                </div>

                <!-- Standard Plan (Popular) -->
                <div class="pricing-card pricing-card-popular" data-aos="fade-up" data-aos-delay="150">
                    <div class="popular-badge">
                        <span>⭐ MOST POPULAR</span>
                    </div>
                    <div class="pricing-header">
                        <h3 class="plan-name">Standard</h3>
                        <p class="plan-description">Best for professionals</p>
                    </div>
                    <div class="pricing-price">
                        <span class="currency">₹</span>
                        <span class="amount">299</span>
                        <span class="period">/month</span>
                    </div>
                    <ul class="pricing-features">
                        <li><span class="check-icon">✓</span> 200 Searches/Month</li>
                        <li><span class="check-icon">✓</span> Mobile Lookup</li>
                        <li><span class="check-icon">✓</span> Aadhaar Lookup</li>
                        <li><span class="check-icon">✓</span> Priority Support</li>
                        <li><span class="check-icon">✓</span> Advanced Analytics</li>
                        <li><span class="check-icon">✓</span> API Access</li>
                    </ul>
                    <a href="register.php" class="btn-pricing btn-pricing-popular">Get Started</a>
                </div>

                <!-- Premium Plan -->
                <div class="pricing-card" data-aos="fade-up" data-aos-delay="200">
                    <div class="pricing-header">
                        <h3 class="plan-name">Premium</h3>
                        <p class="plan-description">For power users</p>
                    </div>
                    <div class="pricing-price">
                        <span class="currency">₹</span>
                        <span class="amount">999</span>
                        <span class="period">/month</span>
                    </div>
                    <ul class="pricing-features">
                        <li><span class="check-icon">✓</span> 1000 Searches/Month</li>
                        <li><span class="check-icon">✓</span> Mobile Lookup</li>
                        <li><span class="check-icon">✓</span> Aadhaar Lookup</li>
                        <li><span class="check-icon">✓</span> 24/7 Support</li>
                        <li><span class="check-icon">✓</span> Advanced Analytics</li>
                        <li><span class="check-icon">✓</span> Full API Access</li>
                        <li><span class="check-icon">✓</span> Custom Integration</li>
                    </ul>
                    <a href="register.php" class="btn-pricing">Get Started</a>
                </div>
            </div>
        </div>
    </section>

    <!-- Testimonials Section -->
    <section id="testimonials" class="testimonials-premium">
        <div class="container">
            <div class="section-header" data-aos="fade-up">
                <span class="section-tag">Testimonials</span>
                <h2 class="section-title">Loved by Thousands</h2>
                <p class="section-subtitle">See what our users have to say</p>
            </div>

            <div class="testimonials-grid">
                <div class="testimonial-card" data-aos="fade-up" data-aos-delay="100">
                    <div class="stars">⭐⭐⭐⭐⭐</div>
                    <p class="testimonial-text">"Gravity has been a game-changer for our business. The accuracy and
                        speed of searches are incredible. Highly recommended!"</p>
                    <div class="testimonial-author">
                        <div class="author-avatar">R</div>
                        <div class="author-info">
                            <div class="author-name">Rahul Sharma</div>
                            <div class="author-role">Business Owner</div>
                        </div>
                    </div>
                </div>

                <div class="testimonial-card" data-aos="fade-up" data-aos-delay="150">
                    <div class="stars">⭐⭐⭐⭐⭐</div>
                    <p class="testimonial-text">"Best platform for mobile and Aadhaar verification. The AI chatbot is
                        super helpful and the interface is beautiful!"</p>
                    <div class="testimonial-author">
                        <div class="author-avatar">P</div>
                        <div class="author-info">
                            <div class="author-name">Priya Patel</div>
                            <div class="author-role">Freelancer</div>
                        </div>
                    </div>
                </div>

                <div class="testimonial-card" data-aos="fade-up" data-aos-delay="200">
                    <div class="stars">⭐⭐⭐⭐⭐</div>
                    <p class="testimonial-text">"Fast, reliable, and affordable. The subscription plans are perfect for
                        our needs. Great customer support too!"</p>
                    <div class="testimonial-author">
                        <div class="author-avatar">A</div>
                        <div class="author-info">
                            <div class="author-name">Amit Kumar</div>
                            <div class="author-role">IT Professional</div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <!-- Trust Badges -->
    <section class="trust-section">
        <div class="container">
            <h3 class="trust-title" data-aos="fade-up">Trusted & Secure</h3>
            <div class="trust-grid">
                <div class="trust-badge" data-aos="zoom-in" data-aos-delay="100">
                    <div class="trust-icon">🔒</div>
                    <div class="trust-name">SSL Secured</div>
                    <div class="trust-desc">256-bit Encryption</div>
                </div>
                <div class="trust-badge" data-aos="zoom-in" data-aos-delay="150">
                    <div class="trust-icon">⚡</div>
                    <div class="trust-name">Fast & Reliable</div>
                    <div class="trust-desc">99.9% Uptime</div>
                </div>
                <div class="trust-badge" data-aos="zoom-in" data-aos-delay="200">
                    <div class="trust-icon">🎯</div>
                    <div class="trust-name">Accurate Data</div>
                    <div class="trust-desc">Verified Sources</div>
                </div>
                <div class="trust-badge" data-aos="zoom-in" data-aos-delay="250">
                    <div class="trust-icon">💬</div>
                    <div class="trust-name">24/7 Support</div>
                    <div class="trust-desc">Always Here</div>
                </div>
                <div class="trust-badge" data-aos="zoom-in" data-aos-delay="300">
                    <div class="trust-icon">🤖</div>
                    <div class="trust-name">AI-Powered</div>
                    <div class="trust-desc">Smart Search</div>
                </div>
                <div class="trust-badge" data-aos="zoom-in" data-aos-delay="350">
                    <div class="trust-icon">🛡️</div>
                    <div class="trust-name">Privacy First</div>
                    <div class="trust-desc">Data Protected</div>
                </div>
            </div>
        </div>
    </section>

    <!-- CTA Section -->
    <section class="cta-premium" data-aos="fade-up">
        <div class="container">
            <div class="cta-content">
                <h2 class="cta-title">Ready to Get Started?</h2>
                <p class="cta-description">Join thousands of users who trust our platform for their intelligence needs.
                </p>
                <a href="register.php" class="btn-cta-primary">
                    <span class="btn-icon">🚀</span>
                    Start Your Free Trial
                    <span class="btn-shine"></span>
                </a>
            </div>
        </div>
    </section>

    <!-- Footer -->
    <footer class="footer-premium">
        <div class="container">
            <div class="footer-grid">
                <!-- Brand Column -->
                <div class="footer-column">
                    <div class="footer-brand">
                        <span class="brand-text">Gravity</span>
                    </div>
                    <p class="footer-description">
                        Advanced Mobile & Aadhaar Intelligence Platform powered by AI.
                        Fast, secure, and reliable intelligence at your fingertips.
                    </p>
                    <div class="footer-social">
                        <a href="#" class="social-link" aria-label="Facebook">
                            <svg width="20" height="20" fill="currentColor" viewBox="0 0 24 24">
                                <path
                                    d="M24 12.073c0-6.627-5.373-12-12-12s-12 5.373-12 12c0 5.99 4.388 10.954 10.125 11.854v-8.385H7.078v-3.47h3.047V9.43c0-3.007 1.792-4.669 4.533-4.669 1.312 0 2.686.235 2.686.235v2.953H15.83c-1.491 0-1.956.925-1.956 1.874v2.25h3.328l-.532 3.47h-2.796v8.385C19.612 23.027 24 18.062 24 12.073z" />
                            </svg>
                        </a>
                        <a href="#" class="social-link" aria-label="Twitter">
                            <svg width="20" height="20" fill="currentColor" viewBox="0 0 24 24">
                                <path
                                    d="M23.953 4.57a10 10 0 01-2.825.775 4.958 4.958 0 002.163-2.723c-.951.555-2.005.959-3.127 1.184a4.92 4.92 0 00-8.384 4.482C7.69 8.095 4.067 6.13 1.64 3.162a4.822 4.822 0 00-.666 2.475c0 1.71.87 3.213 2.188 4.096a4.904 4.904 0 01-2.228-.616v.06a4.923 4.923 0 003.946 4.827 4.996 4.996 0 01-2.212.085 4.936 4.936 0 004.604 3.417 9.867 9.867 0 01-6.102 2.105c-.39 0-.779-.023-1.17-.067a13.995 13.995 0 007.557 2.209c9.053 0 13.998-7.496 13.998-13.985 0-.21 0-.42-.015-.63A9.935 9.935 0 0024 4.59z" />
                            </svg>
                        </a>
                        <a href="#" class="social-link" aria-label="LinkedIn">
                            <svg width="20" height="20" fill="currentColor" viewBox="0 0 24 24">
                                <path
                                    d="M20.447 20.452h-3.554v-5.569c0-1.328-.027-3.037-1.852-3.037-1.853 0-2.136 1.445-2.136 2.939v5.667H9.351V9h3.414v1.561h.046c.477-.9 1.637-1.85 3.37-1.85 3.601 0 4.267 2.37 4.267 5.455v6.286zM5.337 7.433c-1.144 0-2.063-.926-2.063-2.065 0-1.138.92-2.063 2.063-2.063 1.14 0 2.064.925 2.064 2.063 0 1.139-.925 2.065-2.064 2.065zm1.782 13.019H3.555V9h3.564v11.452zM22.225 0H1.771C.792 0 0 .774 0 1.729v20.542C0 23.227.792 24 1.771 24h20.451C23.2 24 24 23.227 24 22.271V1.729C24 .774 23.2 0 22.222 0h.003z" />
                            </svg>
                        </a>
                        <a href="#" class="social-link" aria-label="Instagram">
                            <svg width="20" height="20" fill="currentColor" viewBox="0 0 24 24">
                                <path
                                    d="M12 0C8.74 0 8.333.015 7.053.072 5.775.132 4.905.333 4.14.63c-.789.306-1.459.717-2.126 1.384S.935 3.35.63 4.14C.333 4.905.131 5.775.072 7.053.012 8.333 0 8.74 0 12s.015 3.667.072 4.947c.06 1.277.261 2.148.558 2.913.306.788.717 1.459 1.384 2.126.667.666 1.336 1.079 2.126 1.384.766.296 1.636.499 2.913.558C8.333 23.988 8.74 24 12 24s3.667-.015 4.947-.072c1.277-.06 2.148-.262 2.913-.558.788-.306 1.459-.718 2.126-1.384.666-.667 1.079-1.335 1.384-2.126.296-.765.499-1.636.558-2.913.06-1.28.072-1.687.072-4.947s-.015-3.667-.072-4.947c-.06-1.277-.262-2.149-.558-2.913-.306-.789-.718-1.459-1.384-2.126C21.319 1.347 20.651.935 19.86.63c-.765-.297-1.636-.499-2.913-.558C15.667.012 15.26 0 12 0zm0 2.16c3.203 0 3.585.016 4.85.071 1.17.055 1.805.249 2.227.415.562.217.96.477 1.382.896.419.42.679.819.896 1.381.164.422.36 1.057.413 2.227.057 1.266.07 1.646.07 4.85s-.015 3.585-.074 4.85c-.061 1.17-.256 1.805-.421 2.227-.224.562-.479.96-.899 1.382-.419.419-.824.679-1.38.896-.42.164-1.065.36-2.235.413-1.274.057-1.649.07-4.859.07-3.211 0-3.586-.015-4.859-.074-1.171-.061-1.816-.256-2.236-.421-.569-.224-.96-.479-1.379-.899-.421-.419-.69-.824-.9-1.38-.165-.42-.359-1.065-.42-2.235-.045-1.26-.061-1.649-.061-4.844 0-3.196.016-3.586.061-4.861.061-1.17.255-1.814.42-2.234.21-.57.479-.96.9-1.381.419-.419.81-.689 1.379-.898.42-.166 1.051-.361 2.221-.421 1.275-.045 1.65-.06 4.859-.06l.045.03zm0 3.678c-3.405 0-6.162 2.76-6.162 6.162 0 3.405 2.76 6.162 6.162 6.162 3.405 0 6.162-2.76 6.162-6.162 0-3.405-2.76-6.162-6.162-6.162zM12 16c-2.21 0-4-1.79-4-4s1.79-4 4-4 4 1.79 4 4-1.79 4-4 4zm7.846-10.405c0 .795-.646 1.44-1.44 1.44-.795 0-1.44-.646-1.44-1.44 0-.794.646-1.439 1.44-1.439.793-.001 1.44.645 1.44 1.439z" />
                            </svg>
                        </a>
                    </div>
                </div>

                <!-- Quick Links -->
                <div class="footer-column">
                    <h4 class="footer-title">Quick Links</h4>
                    <ul class="footer-links">
                        <li><a href="#features">Features</a></li>
                        <li><a href="#plans">Pricing</a></li>
                        <li><a href="#testimonials">Testimonials</a></li>
                        <li><a href="register.php">Get Started</a></li>
                    </ul>
                </div>

                <!-- Support -->
                <div class="footer-column">
                    <h4 class="footer-title">Support</h4>
                    <ul class="footer-links">
                        <li><a href="#">Help Center</a></li>
                        <li><a href="#">Documentation</a></li>
                        <li><a href="#">API Reference</a></li>
                        <li><a href="#">Contact Us</a></li>
                    </ul>
                </div>

                <!-- Legal -->
                <div class="footer-column">
                    <h4 class="footer-title">Legal</h4>
                    <ul class="footer-links">
                        <li><a href="#">Privacy Policy</a></li>
                        <li><a href="#">Terms of Service</a></li>
                        <li><a href="#">Cookie Policy</a></li>
                        <li><a href="#">Disclaimer</a></li>
                    </ul>
                </div>
            </div>

            <!-- Footer Bottom -->
            <div class="footer-bottom">
                <p class="footer-copyright">
                    &copy; <?php echo date('Y'); ?> <?php echo SITE_NAME; ?>. All rights reserved.
                </p>
                <p class="footer-tagline">
                    Powered by Gravity Technology
                </p>
            </div>
        </div>
    </footer>

    <!-- Scripts -->
    <script src="https://unpkg.com/aos@2.3.1/dist/aos.js"></script>
    <script src="assets/js/premium-landing.js"></script>
</body>

</html>