<?php
session_start();

// Log logout activity before destroying session
if (isset($_SESSION['user_id'])) {
    try {
        require_once __DIR__ . '/../config/config.php';
        require_once __DIR__ . '/../app/models/Database.php';
        require_once __DIR__ . '/../app/models/ActivityLog.php';
        
        $activityLog = new ActivityLog();
        $activityLog->logActivity(
            $_SESSION['user_id'],
            'logout',
            'User logged out',
            []
        );
    } catch (Exception $e) {
        error_log("Logout activity log error: " . $e->getMessage());
    }
}

session_destroy();
header('Location: login.php');
exit;
