<?php
session_start();
require_once __DIR__ . '/../config/config.php';
require_once __DIR__ . '/../app/models/User.php';
require_once __DIR__ . '/../app/models/Alert.php';

// Check if user is logged in
if (!isset($_SESSION['user_id'])) {
    header('Location: login.php');
    exit;
}

$userModel = new User();
$alertModel = new Alert();
$user = $userModel->getUserById($_SESSION['user_id']);

// Get user's notifications (from alerts table)
$notifications = $alertModel->getUserAlerts($_SESSION['user_id']);
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Notifications - <?php echo SITE_NAME; ?></title>
    
    <!-- Preconnect -->
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link rel="preconnect" href="https://unpkg.com">
    
    <link rel="stylesheet" href="assets/css/style.css">
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@300;400;500;600;700;800&display=swap" rel="stylesheet">
    <link href="https://unpkg.com/aos@2.3.1/dist/aos.css" rel="stylesheet">
</head>
<body>
    <?php include 'includes/user-navbar.php'; ?>

    <div class="container mt-4">
        <!-- Header -->
        <div class="glass-card mb-4" data-aos="fade-up" style="background: linear-gradient(135deg, rgba(102, 126, 234, 0.1) 0%, rgba(118, 75, 162, 0.1) 100%); border: 2px solid rgba(102, 126, 234, 0.3);">
            <div style="display: flex; align-items: center; gap: 20px; flex-wrap: wrap;">
                <div style="background: var(--primary-gradient); width: 80px; height: 80px; border-radius: 15px; display: flex; align-items: center; justify-content: center; flex-shrink: 0; box-shadow: 0 8px 20px rgba(102, 126, 234, 0.3);">
                    <span style="font-size: 36px;">🔔</span>
                </div>
                <div style="flex: 1;">
                    <h2 class="gradient-text" style="margin: 0 0 8px 0; font-size: 24px;">Telegram Notifications</h2>
                    <p style="margin: 0; opacity: 0.8; font-size: 14px;">
                        <?php if (!empty($user['telegram_number'])): ?>
                            📱 Sending to: <strong><?php echo htmlspecialchars($user['telegram_number']); ?></strong>
                        <?php else: ?>
                            ⚠️ <a href="profile.php" style="color: #ffc107;">Add Telegram number</a> to receive notifications
                        <?php endif; ?>
                    </p>
                </div>
            </div>
        </div>

        <!-- Notifications List -->
        <?php if (count($notifications) > 0): ?>
            <div class="row">
                <?php foreach ($notifications as $index => $notification): ?>
                    <div class="col-md-6 mb-3" data-aos="fade-up" data-aos-delay="<?php echo $index * 50; ?>">
                        <div class="glass-card">
                            <div style="display: flex; align-items: flex-start; gap: 15px;">
                                <!-- Icon -->
                                <div style="background: <?php 
                                    echo $notification['type'] === 'telegram' ? 'linear-gradient(135deg, #0088cc 0%, #00aaff 100%)' : 
                                         ($notification['type'] === 'email' ? 'linear-gradient(135deg, #667eea 0%, #764ba2 100%)' : 
                                          'linear-gradient(135deg, #f5576c 0%, #f093fb 100%)'); 
                                ?>; width: 50px; height: 50px; border-radius: 12px; display: flex; align-items: center; justify-content: center; flex-shrink: 0;">
                                    <span style="font-size: 24px;">
                                        <?php 
                                        echo $notification['type'] === 'telegram' ? '📱' : 
                                             ($notification['type'] === 'email' ? '📧' : '🔔'); 
                                        ?>
                                    </span>
                                </div>
                                
                                <!-- Content -->
                                <div style="flex: 1; min-width: 0;">
                                    <div style="display: flex; justify-content: space-between; align-items: flex-start; margin-bottom: 8px;">
                                        <h4 style="margin: 0; font-size: 16px; font-weight: 700;">
                                            <?php echo htmlspecialchars($notification['title']); ?>
                                        </h4>
                                        <span class="badge badge-<?php echo $notification['type'] === 'telegram' ? 'info' : ($notification['type'] === 'email' ? 'primary' : 'warning'); ?>" style="font-size: 11px;">
                                            <?php echo strtoupper($notification['type']); ?>
                                        </span>
                                    </div>
                                    
                                    <p style="margin: 0 0 10px 0; opacity: 0.8; font-size: 14px; word-wrap: break-word;">
                                        <?php echo htmlspecialchars($notification['message']); ?>
                                    </p>
                                    
                                    <div style="display: flex; justify-content: space-between; align-items: center;">
                                        <small style="opacity: 0.6; font-size: 12px;">
                                            🕐 <?php echo date('d M Y, h:i A', strtotime($notification['created_at'])); ?>
                                        </small>
                                        <?php if ($notification['type'] === 'telegram'): ?>
                                            <span style="color: #00ff00; font-size: 12px;">✓ Sent</span>
                                        <?php endif; ?>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                <?php endforeach; ?>
            </div>
        <?php else: ?>
            <!-- No Notifications -->
            <div class="glass-card text-center" data-aos="fade-up">
                <div style="padding: 40px;">
                    <div style="font-size: 64px; margin-bottom: 20px; opacity: 0.5;">🔔</div>
                    <h3 style="margin-bottom: 15px;">No Notifications Yet</h3>
                    <p style="opacity: 0.7; margin-bottom: 20px;">
                        You haven't received any notifications yet. Notifications will appear here when:
                    </p>
                    <div style="text-align: left; max-width: 400px; margin: 0 auto;">
                        <p style="margin: 10px 0;">✅ You make a payment</p>
                        <p style="margin: 10px 0;">✅ You perform a search</p>
                        <p style="margin: 10px 0;">✅ Your subscription is activated</p>
                    </div>
                    <?php if (empty($user['telegram_number'])): ?>
                        <div style="margin-top: 30px; padding: 20px; background: rgba(255, 193, 7, 0.1); border-radius: 15px; border: 1px solid rgba(255, 193, 7, 0.3);">
                            <p style="margin: 0 0 15px 0; color: #ffc107;">
                                💡 <strong>Pro Tip:</strong> Add your Telegram number to receive instant notifications!
                            </p>
                            <a href="profile.php" class="btn btn-primary">
                                📱 Add Telegram Number
                            </a>
                        </div>
                    <?php endif; ?>
                </div>
            </div>
        <?php endif; ?>
    </div>

    <!-- Footer -->
    <footer class="footer">
        <div class="container">
            <p>&copy; <?php echo date('Y'); ?> <?php echo SITE_NAME; ?>. All rights reserved.</p>
        </div>
    </footer>

    <!-- Chat Widget -->
    <?php include 'includes/chat-widget.php'; ?>

    <script src="https://unpkg.com/aos@2.3.1/dist/aos.js"></script>
    <script src="assets/js/toast.js"></script>
    <script>
        AOS.init({
            duration: 1000,
            once: true
        });
    </script>
</body>
</html>
