<?php
session_start();
require_once __DIR__ . '/../../config/config.php';
require_once __DIR__ . '/../../app/models/Plan.php';
require_once __DIR__ . '/../../app/libraries/SimpleRazorpay.php';

header('Content-Type: application/json');

// Check if user is logged in
if (!isset($_SESSION['user_id'])) {
    echo json_encode(['error' => 'Unauthorized']);
    exit;
}

// Get plan ID
$planId = $_POST['plan_id'] ?? null;

if (!$planId) {
    echo json_encode(['error' => 'Plan ID required']);
    exit;
}

try {
    // Get plan details
    $planModel = new Plan();
    $plan = $planModel->getPlanById($planId);
    
    if (!$plan || $plan['status'] !== 'active') {
        echo json_encode(['error' => 'Invalid plan']);
        exit;
    }
    
    // Create Razorpay order using SimpleRazorpay
    $razorpay = new SimpleRazorpay(RAZORPAY_KEY_ID, RAZORPAY_KEY_SECRET);
    
    $orderData = $razorpay->createOrder(
        $plan['price'],
        'INR',
        'plan_' . $planId . '_user_' . $_SESSION['user_id'] . '_' . time()
    );
    
    if (isset($orderData['error'])) {
        echo json_encode([
            'error' => 'Failed to create order',
            'message' => $orderData['message'] ?? 'Unknown error'
        ]);
        exit;
    }
    
    // Save order to session for verification
    $_SESSION['pending_order'] = [
        'order_id' => $orderData['id'],
        'plan_id' => $planId,
        'amount' => $plan['price']
    ];
    
    // Return order details
    echo json_encode([
        'success' => true,
        'order_id' => $orderData['id'],
        'amount' => $orderData['amount'],
        'currency' => $orderData['currency'],
        'key_id' => RAZORPAY_KEY_ID
    ]);
    
} catch (Exception $e) {
    echo json_encode([
        'error' => 'Server error',
        'message' => $e->getMessage()
    ]);
}
