<?php
// Simple API test - no session, no database
require_once __DIR__ . '/../config/config.php';

$testNumber = '8748848829';
$apiUrl = MOBILE_LOOKUP_API_URL . urlencode($testNumber);

echo "<h2>API Test for: $testNumber</h2>";
echo "<hr>";

echo "<h3>1. API URL:</h3>";
echo "<code>$apiUrl</code><br><br>";

echo "<h3>2. Making API Call...</h3>";

$ch = curl_init();
curl_setopt($ch, CURLOPT_URL, $apiUrl);
curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
curl_setopt($ch, CURLOPT_TIMEOUT, 10);
curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);

$response = curl_exec($ch);
$httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
$curlError = curl_error($ch);
curl_close($ch);

echo "HTTP Code: <strong>$httpCode</strong><br>";
echo "Response Length: <strong>" . strlen($response) . " bytes</strong><br>";

if ($curlError) {
    echo "<div style='color: red;'>CURL Error: $curlError</div>";
}

echo "<h3>3. Raw Response:</h3>";
echo "<pre style='background: #f5f5f5; padding: 10px; border-radius: 5px; max-height: 400px; overflow: auto;'>";
echo htmlspecialchars($response);
echo "</pre>";

echo "<h3>4. Decoded JSON:</h3>";
$decoded = json_decode($response, true);
if ($decoded) {
    echo "<pre style='background: #e8f5e9; padding: 10px; border-radius: 5px; max-height: 400px; overflow: auto;'>";
    print_r($decoded);
    echo "</pre>";
} else {
    echo "<div style='color: red;'>Failed to decode JSON!</div>";
    echo "JSON Error: " . json_last_error_msg();
}

echo "<h3>5. Check Config:</h3>";
echo "MOBILE_LOOKUP_API_URL: <code>" . MOBILE_LOOKUP_API_URL . "</code><br>";
echo "AADHAAR_LOOKUP_API_URL: <code>" . AADHAAR_LOOKUP_API_URL . "</code><br>";
?>
