<?php
session_start();

// Simple chat API test
echo "<h2>Chat API Test</h2>";
echo "<hr>";

echo "<h3>1. Session Check:</h3>";
echo "User ID: " . ($_SESSION['user_id'] ?? 'NOT SET') . "<br>";
echo "User Role: " . ($_SESSION['role'] ?? 'NOT SET') . "<br>";
echo "User Name: " . ($_SESSION['user_name'] ?? 'NOT SET') . "<br>";

if (!isset($_SESSION['user_id'])) {
    echo "<div style='color: red;'><strong>ERROR: User not logged in!</strong></div>";
    echo "<p>Please <a href='login.php'>login</a> first.</p>";
    exit;
}

echo "<h3>2. File Check:</h3>";
$configPath = __DIR__ . '/../config/config.php';
$chatModelPath = __DIR__ . '/../app/models/Chat.php';

echo "Config exists: " . (file_exists($configPath) ? '✅ YES' : '❌ NO') . "<br>";
echo "Chat model exists: " . (file_exists($chatModelPath) ? '✅ YES' : '❌ NO') . "<br>";

if (!file_exists($chatModelPath)) {
    echo "<div style='color: red;'><strong>ERROR: Chat.php model not found!</strong></div>";
    exit;
}

echo "<h3>3. Loading Models:</h3>";
try {
    require_once $configPath;
    echo "Config loaded: ✅<br>";
    
    require_once $chatModelPath;
    echo "Chat model loaded: ✅<br>";
    
    $chatModel = new Chat();
    echo "Chat instance created: ✅<br>";
} catch (Exception $e) {
    echo "<div style='color: red;'><strong>ERROR: " . $e->getMessage() . "</strong></div>";
    exit;
}

echo "<h3>4. Test Get Messages:</h3>";
try {
    $userId = $_SESSION['user_id'];
    $messages = $chatModel->getUserMessages($userId);
    echo "Messages retrieved: ✅<br>";
    echo "Count: " . count($messages) . "<br>";
    
    if (count($messages) > 0) {
        echo "<pre>";
        print_r($messages);
        echo "</pre>";
    } else {
        echo "<p>No messages found (this is OK for first time)</p>";
    }
} catch (Exception $e) {
    echo "<div style='color: red;'><strong>ERROR: " . $e->getMessage() . "</strong></div>";
    echo "<pre>" . $e->getTraceAsString() . "</pre>";
}

echo "<h3>5. Test Send Message:</h3>";
try {
    $testMessage = "Test message at " . date('H:i:s');
    $result = $chatModel->sendMessage($_SESSION['user_id'], 'user', $testMessage);
    
    if ($result) {
        echo "Message sent: ✅<br>";
        echo "Message: $testMessage<br>";
    } else {
        echo "<div style='color: red;'>Failed to send message</div>";
    }
} catch (Exception $e) {
    echo "<div style='color: red;'><strong>ERROR: " . $e->getMessage() . "</strong></div>";
    echo "<pre>" . $e->getTraceAsString() . "</pre>";
}

echo "<h3>6. API URL Test:</h3>";
$apiUrl = "http://localhost/gravity/public/api/chat.php?action=get";
echo "API URL: <code>$apiUrl</code><br>";
echo "<a href='$apiUrl' target='_blank'>Test API directly</a>";
?>
