<?php
error_reporting(E_ALL);
ini_set('display_errors', 1);

require_once __DIR__ . '/../config/config.php';
require_once __DIR__ . '/../app/libraries/SimpleMailer.php';

echo "<h1>📧 Email Test</h1>";

// Check SMTP configuration
echo "<h2>1. SMTP Configuration</h2>";
echo "<table border='1' cellpadding='10'>";
echo "<tr><th>Setting</th><th>Value</th><th>Status</th></tr>";

$checks = [
    'SMTP_HOST' => SMTP_HOST,
    'SMTP_PORT' => SMTP_PORT,
    'SMTP_USER' => SMTP_USER,
    'SMTP_PASS' => str_repeat('*', strlen(SMTP_PASS))
];

foreach ($checks as $key => $value) {
    $status = ($value && $value !== 'your_email@gmail.com' && $value !== 'your_app_password') ? '✅' : '⚠️';
    echo "<tr><td><strong>$key</strong></td><td>$value</td><td>$status</td></tr>";
}
echo "</table>";

// Test email sending
echo "<h2>2. Sending Test Email</h2>";

$testEmail = SMTP_USER; // Send to configured email
$subject = "Test Email from Intelligence Platform";
$body = "
<div style='font-family: Arial, sans-serif; max-width: 600px; margin: 0 auto;'>
    <div style='background: linear-gradient(135deg, #667eea 0%, #764ba2 100%); padding: 30px; text-align: center;'>
        <h1 style='color: white; margin: 0;'>🔍 Intelligence Platform</h1>
    </div>
    
    <div style='padding: 30px; background: #f5f5f5;'>
        <h2 style='color: #333;'>Test Email Successful! 🎉</h2>
        
        <p style='color: #666; line-height: 1.6;'>
            This is a test email from your Intelligence Platform.
        </p>
        
        <div style='background: white; padding: 20px; border-radius: 10px; margin: 20px 0;'>
            <h3 style='color: #667eea; margin-top: 0;'>Email Configuration</h3>
            <p><strong>SMTP Host:</strong> " . SMTP_HOST . "</p>
            <p><strong>SMTP Port:</strong> " . SMTP_PORT . "</p>
            <p><strong>From Email:</strong> " . SMTP_USER . "</p>
            <p><strong>Test Time:</strong> " . date('d M Y, h:i:s A') . "</p>
        </div>
        
        <p style='color: #666;'>
            If you received this email, your email configuration is working perfectly! ✅
        </p>
        
        <div style='text-align: center; margin-top: 30px;'>
            <a href='" . SITE_URL . "/public/dashboard.php' 
               style='background: linear-gradient(135deg, #667eea 0%, #764ba2 100%); 
                      color: white; 
                      padding: 15px 30px; 
                      text-decoration: none; 
                      border-radius: 50px; 
                      display: inline-block;'>
                Go to Dashboard
            </a>
        </div>
    </div>
    
    <div style='background: #333; color: white; padding: 20px; text-align: center;'>
        <p style='margin: 0;'>© " . date('Y') . " Intelligence Platform. All rights reserved.</p>
    </div>
</div>
";

echo "<p><strong>Sending to:</strong> $testEmail</p>";
echo "<p><strong>Subject:</strong> $subject</p>";
echo "<p><strong>Method:</strong> Direct SMTP Connection (fsockopen)</p>";

echo "<div style='background: #e7f3ff; border: 1px solid #b3d9ff; padding: 15px; border-radius: 5px; margin: 10px 0;'>";
echo "<strong>📡 Attempting SMTP Connection...</strong><br>";
echo "Host: " . SMTP_HOST . "<br>";
echo "Port: " . SMTP_PORT . "<br>";
echo "User: " . SMTP_USER . "<br>";
echo "</div>";

try {
    $mailer = new SimpleMailer(SMTP_USER, SITE_NAME);
    
    echo "<p>⏳ Sending email...</p>";
    
    $result = $mailer->send($testEmail, $subject, $body);
    
    if ($result) {
        echo "<div style='background: #d4edda; border: 1px solid #c3e6cb; color: #155724; padding: 20px; border-radius: 10px; margin: 20px 0;'>";
        echo "<h3>✅ Email Sent Successfully!</h3>";
        echo "<p><strong>Sent to:</strong> $testEmail</p>";
        echo "<p><strong>Method:</strong> Direct SMTP (TLS)</p>";
        echo "<p>Check your inbox. If you don't see it, check your spam folder.</p>";
        echo "<p><strong>Time:</strong> " . date('h:i:s A') . "</p>";
        echo "</div>";
    } else {
        echo "<div style='background: #f8d7da; border: 1px solid #f5c6cb; color: #721c24; padding: 20px; border-radius: 10px; margin: 20px 0;'>";
        echo "<h3>❌ Email Failed to Send</h3>";
        echo "<p>SMTP connection failed. Please check:</p>";
        echo "<ul>";
        echo "<li>SMTP credentials are correct</li>";
        echo "<li>App password is valid (16 characters)</li>";
        echo "<li>Gmail 2FA is enabled</li>";
        echo "<li>Firewall allows port 587</li>";
        echo "</ul>";
        echo "</div>";
    }
} catch (Exception $e) {
    echo "<div style='background: #f8d7da; border: 1px solid #f5c6cb; color: #721c24; padding: 20px; border-radius: 10px; margin: 20px 0;'>";
    echo "<h3>❌ Error Occurred</h3>";
    echo "<p><strong>Error:</strong> " . htmlspecialchars($e->getMessage()) . "</p>";
    echo "<p><strong>Possible causes:</strong></p>";
    echo "<ul>";
    echo "<li>Invalid SMTP credentials</li>";
    echo "<li>Network/Firewall blocking port 587</li>";
    echo "<li>Gmail security settings</li>";
    echo "</ul>";
    echo "</div>";
}

// Check PHP mail() function
echo "<h2>3. PHP mail() Function Test</h2>";

$headers = "From: " . SMTP_USER . "\r\n";
$headers .= "Reply-To: " . SMTP_USER . "\r\n";
$headers .= "Content-Type: text/html; charset=UTF-8\r\n";

$simpleBody = "<h1>Test Email</h1><p>This is a simple test email using PHP mail() function.</p>";

$mailResult = @mail($testEmail, "Simple Test Email", $simpleBody, $headers);

if ($mailResult) {
    echo "<p style='color: green;'>✅ PHP mail() function returned TRUE</p>";
    echo "<p>Note: This doesn't guarantee delivery. Check your inbox.</p>";
} else {
    echo "<p style='color: red;'>❌ PHP mail() function returned FALSE</p>";
    echo "<p>Your server might not have mail() configured properly.</p>";
}

// Troubleshooting tips
echo "<h2>4. Troubleshooting Tips</h2>";
echo "<div style='background: #fff3cd; border: 1px solid #ffeeba; color: #856404; padding: 20px; border-radius: 10px;'>";
echo "<h3>⚠️ If Email Not Received:</h3>";
echo "<ol>";
echo "<li><strong>Check Spam Folder</strong> - Gmail might mark it as spam</li>";
echo "<li><strong>Verify SMTP Settings</strong> - Make sure all settings are correct</li>";
echo "<li><strong>Check App Password</strong> - Must be 16-character app password, not regular password</li>";
echo "<li><strong>Enable Less Secure Apps</strong> - Or use App Password (recommended)</li>";
echo "<li><strong>Check Server Logs</strong> - Look at error.log for details</li>";
echo "</ol>";
echo "</div>";

echo "<hr>";
echo "<h2>Summary</h2>";
echo "<p><a href='dashboard.php'>← Back to Dashboard</a></p>";
?>
