<?php
require_once __DIR__ . '/../config/config.php';
require_once __DIR__ . '/../app/controllers/Notification.php';
require_once __DIR__ . '/../app/models/User.php';

echo "<h2>Telegram Notification Test</h2>";
echo "<hr>";

// Test 1: Check Configuration
echo "<h3>1. Configuration Check</h3>";
echo "Bot Token: " . (defined('TELEGRAM_BOT_TOKEN') ? '✅ Configured' : '❌ Not configured') . "<br>";
echo "Bot Token Value: " . TELEGRAM_BOT_TOKEN . "<br>";
echo "<hr>";

// Test 2: Send Test Message to Admin
echo "<h3>2. Sending Test Message to Admin</h3>";
$notification = new Notification();
$testMessage = "🧪 <b>Test Notification</b>\n\nThis is a test message from the system.\n\n🕐 Time: " . date('Y-m-d H:i:s');
$result = $notification->sendTelegram($testMessage);
echo "Result: " . ($result ? '✅ Sent successfully' : '❌ Failed') . "<br>";
echo "<hr>";

// Test 3: Get User and Test User-Specific Notification
echo "<h3>3. Testing User-Specific Notification</h3>";

// Get first user with telegram number
$userModel = new User();
$db = $userModel->db;
$stmt = $db->query("SELECT * FROM users WHERE telegram_number IS NOT NULL AND telegram_number != '' LIMIT 1");
$user = $stmt->fetch();

if ($user) {
    echo "Found user: " . htmlspecialchars($user['name']) . "<br>";
    echo "Telegram Number: " . htmlspecialchars($user['telegram_number']) . "<br>";
    
    $userMessage = "🧪 <b>User Test Notification</b>\n\n";
    $userMessage .= "Hello " . $user['name'] . "!\n\n";
    $userMessage .= "This is a test notification sent to your Telegram.\n\n";
    $userMessage .= "🕐 Time: " . date('Y-m-d H:i:s');
    
    $userResult = $notification->sendUserTelegram($user['telegram_number'], $userMessage);
    echo "Result: " . ($userResult ? '✅ Sent successfully to user' : '❌ Failed to send to user') . "<br>";
} else {
    echo "❌ No user found with Telegram number<br>";
    echo "Please add a Telegram number in your profile first.<br>";
}
echo "<hr>";

// Test 4: Check Error Log
echo "<h3>4. Recent Error Log (last 20 lines)</h3>";
$errorLog = 'C:\xampp\apache\logs\error.log';
if (file_exists($errorLog)) {
    $lines = file($errorLog);
    $recentLines = array_slice($lines, -20);
    echo "<pre style='background: #f5f5f5; padding: 10px; border-radius: 5px; max-height: 300px; overflow-y: auto;'>";
    foreach ($recentLines as $line) {
        if (stripos($line, 'telegram') !== false || stripos($line, 'notification') !== false) {
            echo htmlspecialchars($line);
        }
    }
    echo "</pre>";
} else {
    echo "Error log not found at: $errorLog<br>";
}
echo "<hr>";

// Test 5: Instructions
echo "<h3>5. Troubleshooting Steps</h3>";
echo "<ol>";
echo "<li><strong>If admin message failed:</strong> Check TELEGRAM_CHAT_ID in config.php</li>";
echo "<li><strong>If user message failed:</strong> User needs to start a chat with the bot first</li>";
echo "<li><strong>How to get chat_id:</strong>";
echo "<ul>";
echo "<li>Send /start to your bot on Telegram</li>";
echo "<li>Visit: https://api.telegram.org/bot" . TELEGRAM_BOT_TOKEN . "/getUpdates</li>";
echo "<li>Look for 'chat':{'id': YOUR_CHAT_ID}</li>";
echo "</ul>";
echo "</li>";
echo "<li><strong>Telegram number format:</strong> Should be the chat_id (numeric), not phone number</li>";
echo "</ol>";

echo "<hr>";
echo "<h3>6. Quick Links</h3>";
echo "<a href='https://api.telegram.org/bot" . TELEGRAM_BOT_TOKEN . "/getMe' target='_blank'>Check Bot Info</a><br>";
echo "<a href='https://api.telegram.org/bot" . TELEGRAM_BOT_TOKEN . "/getUpdates' target='_blank'>Get Recent Updates (to find chat_id)</a><br>";
?>
