<?php
session_start();
require_once __DIR__ . '/../config/config.php';
require_once __DIR__ . '/../app/models/Chat.php';

// Simulate a logged-in user
$_SESSION['user_id'] = 4; // Test with user ID 4
$_SESSION['role'] = 'user';

echo "<h2>Chat Debug Test</h2>";
echo "<p>Session User ID: " . ($_SESSION['user_id'] ?? 'NOT SET') . "</p>";
echo "<p>Session Role: " . ($_SESSION['role'] ?? 'NOT SET') . "</p>";

$chatModel = new Chat();

// Test 1: Get messages
echo "<h3>Test 1: Get Messages</h3>";
try {
    $messages = $chatModel->getUserMessages(4);
    echo "<p>Messages count: " . count($messages) . "</p>";
    echo "<pre>" . print_r($messages, true) . "</pre>";
} catch (Exception $e) {
    echo "<p style='color: red;'>Error: " . $e->getMessage() . "</p>";
}

// Test 2: Send a message
echo "<h3>Test 2: Send Message</h3>";
try {
    $testMessage = "Test message at " . date('H:i:s');
    $result = $chatModel->sendMessage(4, 'user', $testMessage);
    echo "<p>Send result: " . ($result ? 'SUCCESS' : 'FAILED') . "</p>";
    
    if ($result) {
        echo "<p>Message sent: $testMessage</p>";
        
        // Verify it was saved
        $messages = $chatModel->getUserMessages(4);
        echo "<p>New message count: " . count($messages) . "</p>";
    }
} catch (Exception $e) {
    echo "<p style='color: red;'>Error: " . $e->getMessage() . "</p>";
}

// Test 3: Check database connection
echo "<h3>Test 3: Database Connection</h3>";
try {
    $db = Database::getInstance()->getConnection();
    echo "<p>Database connected: YES</p>";
    
    $stmt = $db->query("SELECT DATABASE() as db_name");
    $dbName = $stmt->fetch();
    echo "<p>Current database: " . $dbName['db_name'] . "</p>";
    
    $stmt = $db->query("SHOW TABLES LIKE 'chat_messages'");
    $tableExists = $stmt->fetch();
    echo "<p>chat_messages table exists: " . ($tableExists ? 'YES' : 'NO') . "</p>";
    
} catch (Exception $e) {
    echo "<p style='color: red;'>Error: " . $e->getMessage() . "</p>";
}
