&lt;?php
session_start();
require_once '../app/models/Database.php';
require_once '../app/models/AIChatbot.php';

// Test user ID (change this to your actual user ID)
$testUserId = 1;

// Test messages
$testMessages = [
    "Show my last 5 searches",
    "last 5 searches",
    "recent searches",
    "search history",
    "my searches"
];

$chatbot = new AIChatbot();

echo "&lt;!DOCTYPE html&gt;\n";
echo "&lt;html&gt;\n";
echo "&lt;head&gt;\n";
echo "    &lt;title&gt;Chatbot Pattern Test&lt;/title&gt;\n";
echo "    &lt;style&gt;\n";
echo "        body { font-family: Arial, sans-serif; padding: 20px; background: #1a1a2e; color: #fff; }\n";
echo "        .test-case { background: #16213e; padding: 15px; margin: 10px 0; border-radius: 8px; border-left: 4px solid #0f3460; }\n";
echo "        .query { color: #4ade80; font-weight: bold; }\n";
echo "        .response { background: #0f3460; padding: 10px; margin-top: 10px; border-radius: 5px; white-space: pre-wrap; }\n";
echo "        .success { border-left-color: #4ade80; }\n";
echo "        .fail { border-left-color: #f5576c; }\n";
echo "        h1 { color: #4ade80; }\n";
echo "    &lt;/style&gt;\n";
echo "&lt;/head&gt;\n";
echo "&lt;body&gt;\n";
echo "    &lt;h1&gt;🤖 Chatbot Pattern Matching Test&lt;/h1&gt;\n";
echo "    &lt;p&gt;Testing 'Recent Searches' pattern matching with User ID: $testUserId&lt;/p&gt;\n";

foreach ($testMessages as $message) {
    echo "    &lt;div class='test-case'&gt;\n";
    echo "        &lt;div class='query'&gt;Query: \"$message\"&lt;/div&gt;\n";
    
    $response = $chatbot-&gt;generateResponse($testUserId, $message);
    
    $isSuccess = strpos($response, 'Recent Searches') !== false || 
                 strpos($response, 'No searches found') !== false;
    
    if ($isSuccess) {
        echo "        &lt;div style='color: #4ade80; margin-top: 5px;'&gt;✅ Pattern Matched!&lt;/div&gt;\n";
    } else {
        echo "        &lt;div style='color: #f5576c; margin-top: 5px;'&gt;❌ Pattern Not Matched&lt;/div&gt;\n";
    }
    
    echo "        &lt;div class='response'&gt;$response&lt;/div&gt;\n";
    echo "    &lt;/div&gt;\n";
}

echo "&lt;/body&gt;\n";
echo "&lt;/html&gt;\n";
?&gt;
