-- ========================================
-- GRAVITY PLATFORM - DATABASE UPDATES
-- ========================================
-- This script updates all platform references to "Gravity"
-- Run this script in your MySQL database

USE mobile_aadhaar_platform;

-- Update chatbot quick responses to use "Gravity" and personalize with user name
UPDATE chatbot_quick_responses 
SET response = 'Hello {name}! 👋 Welcome to Gravity. How can I help you today?'
WHERE keywords LIKE '%hello%' OR keywords LIKE '%hi%';

-- Update system prompt to use "Gravity" and instruct AI to use user's name
UPDATE chatbot_settings 
SET system_prompt = 'You are a helpful AI assistant for Gravity. Always greet users by their name when responding. Answer user questions about subscriptions, mobile/aadhaar searches, pricing, and features. Be concise, friendly, and helpful. If you don''t know something, suggest contacting admin.'
WHERE id = 1;

-- Verify updates
SELECT 'Quick Responses Updated:' as Status;
SELECT * FROM chatbot_quick_responses WHERE keywords LIKE '%hello%';

SELECT 'System Prompt Updated:' as Status;
SELECT system_prompt FROM chatbot_settings WHERE id = 1;

-- Done!
SELECT '✅ All database updates completed successfully!' as Result;
