✅ COIN DEDUCTION FIX IMPLEMENTED
================================

PROBLEM IDENTIFIED:
-------------------
Users' coins were NOT being deducted after performing searches.

ROOT CAUSE:
-----------
The Database.php update() method had a parameter handling bug. When the User.php 
updateWalletBalance() method called update() with named parameters like:

    $this->db->update('wallets', ['balance' => $newBalance], 'user_id = :uid', [':uid' => $userId]);

The update() method was trying to replace '?' placeholders with named parameters,
but wasn't properly handling the named parameters passed in whereParams array.

FILES FIXED:
-------------
1. ✅ classes/Database.php - Fixed update() method parameter handling
2. ✅ classes/User.php - Added detailed error logging to updateWalletBalance()

CHANGES MADE:
--------------

1. DATABASE.PHP - update() method:
   - Now properly detects if parameters are named (:uid) or positional (?)
   - If array has string keys (named params), merges them directly
   - If array has numeric keys (positional), replaces ? with named parameters
   - Added comprehensive error logging

2. USER.PHP - updateWalletBalance() method:
   - Added detailed logging for every wallet update/insert operation
   - Logs show: User ID, Current Balance, Amount, New Balance
   - Helps debug future issues quickly

HOW IT WORKS NOW:
------------------
When user performs a search:

1. Dashboard.php receives search request
2. Calls $search->mobileSearch() or $search->aadhaarSearch()
3. Search.php gets search cost from config (1 coin for mobile, 5 for aadhaar)
4. Checks user wallet balance
5. If balance sufficient → deducts coins via $user->updateWalletBalance($userId, -$cost)
6. Updates wallet in database successfully ✅
7. Returns updated balance to frontend

DATABASE WALLETS TABLE:
-----------------------
CREATE TABLE wallets (
    id INT PRIMARY KEY AUTO_INCREMENT,
    user_id INT NOT NULL,
    balance DECIMAL(10,2) DEFAULT 0.00,
    updated_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
    FOREIGN KEY (user_id) REFERENCES users(id) ON DELETE CASCADE
);

TESTING:
--------
Access: /test_coin_deduction.php (logged in as user)
- Shows current wallet balance
- Shows search costs
- Can test manual deduction
- Shows recent searches
- Displays wallet update logs

ERROR LOGS:
-----------
Check your error_log for entries like:
WALLET UPDATE - User: 5 | Current: 100 | Amount: -1 | New: 99
WALLET UPDATE RESULT: SUCCESS

KEY FILES INVOLVED:
-------------------
- classes/Database.php (fixed)
- classes/User.php (enhanced with logging)
- classes/Search.php (calls updateWalletBalance)
- user/dashboard.php (receives search requests)
- config/config.php (defines search costs)

COINS DEDUCTED IN LIVE MODE:
-----------------------------
✅ Mobile search: 1 coin per search
✅ Aadhaar search: 5 coins per search
✅ Refunds if API fails
✅ Caching fallback data (no extra charge)

TO VERIFY:
----------
1. Test on live server: https://simplechecks.xyz/extract/
2. Perform a mobile search - coins should deduct ✅
3. Perform an aadhaar search - coins should deduct ✅
4. Check wallet balance updates
5. Check error_log for "WALLET UPDATE - SUCCESS" messages
