<?php
/**
 * Reset Email Settings to Correct Values
 */

require_once 'config/config.php';
require_once 'classes/Database.php';

$db = Database::getInstance();

echo "=== Resetting Email Settings ===\n\n";

$settings = [
    'email_mode' => 'smtp',
    'mail_host' => 'smtp.gmail.com',
    'mail_port' => '465',
    'mail_encryption' => 'ssl',
    'mail_username' => 's26118152@gmail.com',
    'mail_from_email' => 's26118152@gmail.com',
    'mail_from_name' => 'Advanced Mobile Info'
];

foreach ($settings as $key => $value) {
    $result = $db->update(
        'admin_settings',
        ['setting_value' => $value],
        'setting_key = ?',
        [$key]
    );
    echo "Updated: $key = $value (" . ($result ? 'Success' : 'Failed') . ")\n";
}

echo "\n✅ Email settings reset to correct values!\n\n";

echo "=== Current Settings ===\n";
$all = $db->fetchAll('SELECT setting_key, setting_value FROM admin_settings WHERE setting_key LIKE "mail%" OR setting_key = "email_mode" ORDER BY setting_key');

foreach ($all as $row) {
    echo $row['setting_key'] . " = " . $row['setting_value'] . "\n";
}

?>
