<?php
require_once(__DIR__ . '/../config/config.php');
require_once(__DIR__ . '/../classes/Database.php');
require_once(__DIR__ . '/../classes/Auth.php');
require_once(__DIR__ . '/../classes/Payment.php');

session_start();

$db = Database::getInstance();
$auth = new Auth($db);

// Check admin access
if (!$auth->isLoggedIn() || !$auth->isAdmin()) {
    http_response_code(403);
    die(json_encode(['status' => 'error', 'message' => 'Unauthorized']));
}

header('Content-Type: application/json');

$payment = new Payment();

// Check if last request was recent (for preventing duplicate notifications)
$lastCheck = $_SESSION['last_notification_check'] ?? 0;
$now = time();
$isNew = ($now - $lastCheck) > 10; // Show new if more than 10 seconds since last check
$_SESSION['last_notification_check'] = $now;

$pendingApprovals = $payment->getPendingApprovals(10);

echo json_encode([
    'status' => 'success',
    'notifications' => $pendingApprovals,
    'count' => count($pendingApprovals),
    'is_new' => $isNew && count($pendingApprovals) > 0
]);
?>
