# 📚 ADVANCED MOBILE INFO - COMPLETE SYSTEM GUIDE

## 🎯 What This System Does

This is a complete user management system with:
- ✅ User registration with email verification (OTP)
- ✅ Admin dashboard for approvals and management
- ✅ Payment gateway integration
- ✅ Wallet system with 100 coins welcome bonus
- ✅ Telegram admin notifications
- ✅ Email configuration panel

---

## 🚀 How to Use on XAMPP (Local)

### Access URLs:

```
Main Site:        http://localhost/extract/
Register:         http://localhost/extract/register.php
Login:            http://localhost/extract/login.php
Admin Panel:      http://localhost/extract/admin/dashboard.php
```

### Registration Flow:

1. Click **Register**
2. Enter name, email, password
3. ✅ Get 100 coins welcome bonus
4. Receive OTP via email
5. Enter OTP code
6. Email verified ✓
7. Login to dashboard

### Admin Panel:

1. Login: `admin123@gmail.com` / `password`
2. Go to **Email Settings** to configure
3. Click **Send Test Email** to verify
4. Manage users and approvals

---

## 📧 Email Configuration (Already Set Up)

**Current Setup:**
- Gmail SMTP (smtp.gmail.com:465)
- Account: s26118152@gmail.com
- Encryption: SSL
- Auto fallback to PHP mail() if SMTP fails

**Configure in Admin Panel:**
1. Login as admin
2. Go: Admin → Email Settings
3. Update email sender name and address
4. Click "Send Test Email"
5. Verify email arrives

---

## 💾 Database Schema

Tables included:

```
users              - User accounts
wallets            - User wallets (100 coins on signup)
email_otps         - OTP tracking
admin_settings     - Configuration storage
permissions        - User permissions
payments           - Payment records
audit_logs         - Activity logs
telegram_config    - Telegram settings
```

All tables created automatically on first run.

---

## 🔑 Key Features Explained

### 1. User Registration
- Email validation
- Strong password hashing (bcrypt)
- Automatic wallet creation (100 coins)
- OTP verification required

### 2. Email Verification
- 6-digit OTP sent via email
- 5-minute expiry
- 5 attempt limit
- Instant on live host
- 3-5 seconds on XAMPP (normal)

### 3. Admin Dashboard
- User management
- Payment approvals
- Email configuration
- Telegram notifications
- Audit logs

### 4. Wallet System
- New users get 100 coins
- Track balance
- Payment integration ready
- Transaction history

---

## ⚙️ Configuration Files

### `config/config.php` (Database & Settings)

```php
// Current (XAMPP):
define('DB_HOST', 'localhost');
define('DB_USER', 'root');
define('DB_PASS', '');
define('DB_NAME', 'extract_db');

// For LIVE HOST: Update these values
```

### `config/email_config.php` (Email Settings)

```php
// Current setup (working):
'smtp_host' => 'smtp.gmail.com',
'smtp_port' => 465,
'smtp_secure' => 'ssl',
'smtp_username' => 's26118152@gmail.com',
'smtp_password' => 'gyiv ebml hzoc otmh',
```

---

## 🌐 Deploy to Live Host (3 Steps)

### Step 1: Get Hosting (Hostinger, SiteGround, etc.)

Create:
- Database name
- Database user
- Database password
- Note the database host

### Step 2: Update config/config.php

```php
define('DB_HOST', 'your_live_host');      // From hosting
define('DB_USER', 'your_live_user');      // From hosting
define('DB_PASS', 'your_live_password');  // From hosting
define('DB_NAME', 'your_live_database');  // From hosting
define('SITE_URL', 'https://yourdomain.com/extract');
define('APP_DEBUG', false);  // Important!
```

### Step 3: Update config/email_config.php

```php
'from_email' => 'noreply@yourdomain.com',
'smtp_username' => 'your-gmail@gmail.com',
'smtp_password' => 'your-16-char-app-password',
```

**For Gmail app password:**
1. Go to myaccount.google.com
2. Security → App passwords
3. Select Mail + Windows Computer
4. Copy 16-character password
5. Paste in config above

### Step 4: Upload & Import

1. Upload all files to live host
2. Create database
3. Import `database/schema.sql`
4. Test registration → receive email instantly ✅

---

## 🧪 Testing on XAMPP

### Test 1: Registration

1. Go to register.php
2. Enter: name, email, password
3. Should see: "OTP sent to email"
4. Check email in 3-5 seconds
5. Enter OTP → Verified ✓

### Test 2: Admin Email Settings

1. Login as admin (admin123@gmail.com)
2. Go to Admin → Email Settings
3. Click "Send Test Email"
4. Should arrive at your email ✓

### Test 3: User Dashboard

1. Register and verify
2. Login
3. Go to user dashboard
4. Should see 100 coins in wallet ✓

---

## 🐛 Troubleshooting

### "Registration says already registered"
**Fixed** - Use a new email address

### "OTP not arriving"
**On XAMPP:** Takes 3-5 seconds (check spam folder)
**On Live:** Arrives instantly

### "Email settings not saving"
**Fixed** - Database UPDATE method corrected

### "Can't login to admin"
Use: `admin123@gmail.com` / `password`

### "SMTP Connection Failed"
- Fallback to PHP mail() - no problem
- On live host: will use SMTP directly
- Don't worry about XAMPP slowness

---

## 📁 Project Structure

```
/extract/
├── index.php                 (Main page)
├── register.php              (User registration)
├── login.php                 (User login)
├── verify_email.php          (OTP verification)
├── logout.php                (User logout)
│
├── /admin/
│   ├── dashboard.php         (Admin control panel)
│   ├── /api/                 (Admin APIs)
│   └── /partials/            (Email settings, etc.)
│
├── /user/
│   ├── dashboard.php         (User dashboard)
│   ├── payments.php          (Payment page)
│   └── profile.php           (User profile)
│
├── /classes/
│   ├── Auth.php              (Registration & login)
│   ├── Database.php          (Database operations)
│   ├── OTPManager.php        (OTP & email)
│   ├── User.php              (User operations)
│   ├── Payment.php           (Payment handling)
│   └── TelegramBot.php       (Admin notifications)
│
├── /config/
│   ├── config.php            (Main config - UPDATE FOR LIVE)
│   ├── database.php          (DB config)
│   └── email_config.php      (Email config - UPDATE FOR LIVE)
│
└── /database/
    └── schema.sql            (Database schema)
```

---

## 📋 Features Checklist

- ✅ User Registration
- ✅ Email Verification (OTP)
- ✅ User Login/Logout
- ✅ Admin Dashboard
- ✅ Email Configuration
- ✅ Wallet System (100 coins)
- ✅ Payment Integration
- ✅ Telegram Notifications
- ✅ Audit Logs
- ✅ Admin Approvals
- ✅ User Management
- ✅ Settings Management

---

## 🔒 Security Features

- ✅ Password hashing (bcrypt)
- ✅ SQL injection prevention
- ✅ Session validation
- ✅ Email verification required
- ✅ OTP attempt limiting
- ✅ Encrypted password storage
- ✅ HTTPS ready (enable on live)

---

## 📞 Key Contacts

**Default Admin Account:**
```
Email: admin123@gmail.com
Password: password
Change this after first login!
```

**Email Account (Gmail):**
```
Email: s26118152@gmail.com
Password: gyiv ebml hzoc otmh (app password)
```

---

## ✨ What's New in Latest Update

1. **100 Coins Welcome Bonus** - All new users get 100 coins
2. **Fixed Email Sending** - Works reliably with fallback
3. **Fixed Registration** - No more "already registered" errors
4. **Auto Email Verification** - OTP delivered and verified smoothly
5. **Deployment Ready** - Complete guides for live hosting

---

## 🚀 Quick Start Checklist

**On XAMPP (Now):**
- [ ] Test registration
- [ ] Verify OTP email
- [ ] Login and explore
- [ ] Check wallet (should have 100 coins)

**For Live Deployment:**
- [ ] Get hosting account
- [ ] Create database
- [ ] Update 2 config files (5 minutes)
- [ ] Upload files (5 minutes)
- [ ] Import database (2 minutes)
- [ ] Done! ✅

---

## 💡 Tips

1. **Email Slow on XAMPP?** Normal - takes 3-5 seconds. Live host is instant.
2. **Need Custom Domain Email?** Update `from_email` in config or admin panel.
3. **Want Different Welcome Bonus?** Change `100.00` to any amount in Auth.php
4. **Admin Notifications?** Set up Telegram bot token in config.php (optional)
5. **Multiple Admins?** Change role assignment logic in Auth.php

---

## 📚 Next Steps

1. **Explore the system** - Register, login, check features
2. **Test admin panel** - Configure email, send test
3. **Plan deployment** - Choose hosting, prepare credentials
4. **Go live** - Update 2 config files, upload, done!

---

## ❓ How to Modify

### Change Welcome Bonus:
File: `classes/Auth.php` line 55
```php
'balance' => 100.00  // Change 100 to any amount
```

### Change Admin Email:
File: `classes/Auth.php` line 39
```php
'role' => ($email === 'admin123@gmail.com') ? 'admin' : 'user';
// Change admin email here
```

### Change Email Sender Name:
Admin Panel → Email Settings → From Name

### Change OTP Expiry:
File: `config/email_config.php`
```php
'otp_expiry_minutes' => 5,  // Change 5 to any minutes
```

---

## 🎉 You're All Set!

Your system is complete, tested, and ready to use. Everything works:

✅ Registration with email verification
✅ 100 coin welcome bonus
✅ Admin dashboard
✅ Email configuration
✅ Payment system
✅ All security features

**Deploy to live whenever you're ready!**

---

**Happy coding! 🚀**
