<?php
require_once __DIR__ . '/../../classes/Database.php';
$db = Database::getInstance();

$ticketId = intval($_GET['ticket'] ?? 0);

$msgs = $db->fetchAll(
    "SELECT * FROM support_messages WHERE ticket_id = :tid ORDER BY created_at ASC",
    [':tid' => $ticketId]
);

if (!$msgs) {
    echo "<p class='text-muted'>No messages yet.</p>";
    exit;
}

foreach ($msgs as $m) {
    $isAdmin = $m['sender_id'] == 1;
    $align = $isAdmin ? "text-end" : "text-start";

    echo "
    <div class='$align bg-white border p-2 rounded mb-2 position-relative'>
        <small>".htmlspecialchars($m['message'])."</small><br>
        <small class='text-muted'>".date('M d, H:i', strtotime($m['created_at']))."</small>
        <a href='?page=support&delete_msg={$m['id']}' 
           class='text-danger position-absolute top-0 end-0 me-1' 
           style='font-size:12px;'>🗑️</a>
    </div>";
}
