<?php
/**
 * For Local Testing - Show OTP on Screen
 * In production, the OTP will be sent via email
 */

session_start();
require_once 'config/config.php';
require_once 'classes/Database.php';
require_once 'classes/OTPManager.php';

$db = Database::getInstance();

$email = $_SESSION['registration_email'] ?? '';

if (empty($email)) {
    header('Location: register.php');
    exit();
}

// Get the OTP from database (for development/testing)
$otpRecord = $db->fetch(
    'SELECT otp, expires_at FROM email_otps WHERE email = ? ORDER BY created_at DESC LIMIT 1',
    [$email]
);

$testOTP = $otpRecord ? $otpRecord['otp'] : 'NOT FOUND';
$expiryTime = $otpRecord ? $otpRecord['expires_at'] : '';
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>OTP Sent - <?php echo APP_NAME; ?></title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <style>
        body {
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            min-height: 100vh;
            display: flex;
            align-items: center;
            justify-content: center;
            padding: 20px;
        }
        
        .info-box {
            background: white;
            border-radius: 16px;
            padding: 40px;
            max-width: 500px;
            width: 100%;
            box-shadow: 0 20px 60px rgba(0,0,0,0.3);
        }
        
        .otp-display {
            background: #f0f7ff;
            border: 2px solid #667eea;
            border-radius: 12px;
            padding: 20px;
            margin: 20px 0;
            text-align: center;
        }
        
        .otp-code {
            font-size: 48px;
            font-weight: bold;
            color: #667eea;
            letter-spacing: 10px;
            font-family: 'Courier New', monospace;
        }
        
        .note {
            background: #ffeaa7;
            border-left: 4px solid #fdcb6e;
            padding: 15px;
            border-radius: 5px;
            margin: 20px 0;
            color: #d63031;
        }
        
        .btn-proceed {
            width: 100%;
            padding: 12px;
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            color: white;
            border: none;
            border-radius: 10px;
            font-weight: 600;
            margin-top: 20px;
        }
        
        .email-info {
            background: #e8f5e9;
            padding: 15px;
            border-radius: 8px;
            margin: 15px 0;
            color: #2e7d32;
        }
    </style>
</head>
<body>
    <div class="info-box">
        <h2 style="text-align: center; margin-bottom: 20px;">✅ Registration Success!</h2>
        
        <div class="email-info">
            <strong>📧 Email:</strong> <?php echo htmlspecialchars($email); ?>
        </div>
        
        <div class="note">
            <strong>⚠️ DEVELOPMENT MODE:</strong><br>
            Since this is localhost, the OTP is shown below for testing.<br>
            In production, you'll receive it via email.
        </div>
        
        <h5 style="text-align: center; margin: 20px 0;">Your OTP Code:</h5>
        <div class="otp-display">
            <div class="otp-code"><?php echo htmlspecialchars($testOTP); ?></div>
            <small style="color: #999;">Expires: <?php echo $expiryTime; ?></small>
        </div>
        
        <p style="text-align: center; color: #666;">
            📋 Copy the code above and proceed to verification
        </p>
        
        <a href="verify_otp.php" class="btn btn-proceed">
            Enter OTP →
        </a>
        
        <hr>
        
        <p style="font-size: 13px; color: #999; text-align: center; margin-top: 20px;">
            This page is for testing. In production, OTPs are sent to your email.
        </p>
    </div>
</body>
</html>
