<?php
require_once 'config/config.php';
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Privacy Policy - <?php echo APP_NAME; ?></title>
    
    <!-- Bootstrap CSS -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <!-- Feather Icons -->
    <script src="https://unpkg.com/feather-icons"></script>
    
    <style>
        :root {
            --primary-color: #007AFF;
            --secondary-color: #F2F2F7;
            --text-color: #1C1C1E;
            --light-gray: #F5F6F8;
            --border-color: #E5E5EA;
            --shadow-color: rgba(0, 0, 0, 0.1);
        }
        
        * {
            font-family: -apple-system, BlinkMacSystemFont, "Segoe UI", Roboto, "Helvetica Neue", Arial, sans-serif;
        }
        
        body {
            background: var(--light-gray);
            color: var(--text-color);
        }
        
        .navbar {
            background: rgba(255, 255, 255, 0.95);
            backdrop-filter: blur(10px);
            border-bottom: 1px solid var(--border-color);
        }
        
        .navbar-brand {
            font-weight: 700;
            color: var(--text-color) !important;
        }
        
        .content-container {
            background: white;
            border-radius: 16px;
            box-shadow: 0 4px 20px var(--shadow-color);
            padding: 2rem;
            margin: 2rem 0;
        }
        
        .content-header {
            text-align: center;
            margin-bottom: 2rem;
            padding-bottom: 1.5rem;
            border-bottom: 1px solid var(--border-color);
        }
        
        .content-title {
            font-size: 2.5rem;
            font-weight: 700;
            background: linear-gradient(135deg, #007AFF 0%, #0056CC 100%);
            -webkit-background-clip: text;
            -webkit-text-fill-color: transparent;
            background-clip: text;
            margin-bottom: 0.5rem;
        }
        
        .content-subtitle {
            color: #6C757D;
            font-size: 1.1rem;
        }
        
        .section-title {
            font-size: 1.5rem;
            font-weight: 600;
            color: var(--primary-color);
            margin: 2rem 0 1rem 0;
        }
        
        .section-content {
            line-height: 1.6;
            margin-bottom: 1.5rem;
        }
        
        .footer {
            background: rgba(255, 255, 255, 0.95);
            backdrop-filter: blur(10px);
            border-top: 1px solid var(--border-color);
            padding: 2rem 0;
            margin-top: 4rem;
        }
    </style>
</head>
<body>
    <!-- Navigation -->
    <nav class="navbar navbar-expand-lg fixed-top">
        <div class="container">
            <a class="navbar-brand" href="index.php">
                <i data-feather="smartphone" class="me-2"></i>
                <?php echo APP_NAME; ?>
            </a>
            <button class="navbar-toggler" type="button" data-bs-toggle="collapse" data-bs-target="#navbarNav">
                <span class="navbar-toggler-icon"></span>
            </button>
            <div class="collapse navbar-collapse" id="navbarNav">
                <ul class="navbar-nav ms-auto">
                    <li class="nav-item">
                        <a class="nav-link" href="index.php">Home</a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link" href="login.php">Login</a>
                    </li>
                    <?php if (ALLOW_REGISTRATION): ?>
                    <li class="nav-item">
                        <a class="nav-link" href="register.php">Register</a>
                    </li>
                    <?php endif; ?>
                </ul>
            </div>
        </div>
    </nav>

    <!-- Main Content -->
    <div class="container" style="margin-top: 100px;">
        <div class="content-container">
            <div class="content-header">
                <h1 class="content-title">Privacy Policy</h1>
                <p class="content-subtitle">Last updated: January 1, 2024</p>
            </div>
            
            <h2 class="section-title">1. Introduction</h2>
            <div class="section-content">
                Welcome to <?php echo APP_NAME; ?>. We respect your privacy and are committed to protecting your personal data. This privacy policy explains how we collect, use, and safeguard your information when you use our services.
            </div>
            
            <h2 class="section-title">2. Information We Collect</h2>
            <div class="section-content">
                We collect the following types of information:
                <ul>
                    <li><strong>Personal Information:</strong> Name, email address, and account credentials</li>
                    <li><strong>Search Data:</strong> Mobile numbers and Aadhaar numbers you search for</li>
                    <li><strong>Usage Data:</strong> Search history, timestamps, and system interactions</li>
                    <li><strong>Technical Data:</strong> IP address, browser type, and device information</li>
                </ul>
            </div>
            
            <h2 class="section-title">3. How We Use Your Information</h2>
            <div class="section-content">
                We use your information to:
                <ul>
                    <li>Provide and maintain our services</li>
                    <li>Process search queries and return results</li>
                    <li>Manage user accounts and wallet balances</li>
                    <li>Improve our services and user experience</li>
                    <li>Communicate important updates and notifications</li>
                    <li>Ensure security and prevent fraud</li>
                </ul>
            </div>
            
            <h2 class="section-title">4. Data Security</h2>
            <div class="section-content">
                We implement appropriate security measures to protect your data:
                <ul>
                    <li>Encrypted password storage using bcrypt</li>
                    <li>Secure database connections and access controls</li>
                    <li>Regular security audits and updates</li>
                    <li>Limited access to personal information</li>
                    <li>Secure API communications</li>
                </ul>
            </div>
            
            <h2 class="section-title">5. Data Retention</h2>
            <div class="section-content">
                We retain your information for as long as necessary to provide our services and comply with legal obligations. Search logs are maintained for audit purposes and system improvement.
            </div>
            
            <h2 class="section-title">6. Third-Party Services</h2>
            <div class="section-content">
                We may use third-party services for:
                <ul>
                    <li>External API calls for mobile and Aadhaar information</li>
                    <li>Payment processing for wallet recharges</li>
                    <li>Analytics and performance monitoring</li>
                </ul>
                These services have their own privacy policies that you should review.
            </div>
            
            <h2 class="section-title">7. Your Rights</h2>
            <div class="section-content">
                You have the right to:
                <ul>
                    <li>Access your personal information</li>
                    <li>Correct inaccurate data</li>
                    <li>Request deletion of your account</li>
                    <li>Export your data</li>
                    <li>Opt-out of certain data uses</li>
                </ul>
            </div>
            
            <h2 class="section-title">8. Changes to This Policy</h2>
            <div class="section-content">
                We may update this privacy policy from time to time. We will notify you of any changes by posting the new policy on this page and updating the "Last updated" date.
            </div>
            
            <h2 class="section-title">9. Contact Us</h2>
            <div class="section-content">
                If you have questions about this privacy policy or your personal data, please contact us at:
                <br><br>
                <strong>Email:</strong> admin123@gmail.com<br>
                <strong>Phone:</strong> +91 9876543210
            </div>
        </div>
    </div>

    <!-- Footer -->
    <footer class="footer">
        <div class="container">
            <div class="row">
                <div class="col-md-6 text-center text-md-start">
                    <p class="mb-0">&copy; 2024 <?php echo APP_NAME; ?>. All rights reserved.</p>
                </div>
                <div class="col-md-6 text-center text-md-end">
                    <a href="privacy.php" class="text-decoration-none me-3">Privacy Policy</a>
                    <a href="contact.php" class="text-decoration-none me-3">Support</a>
                    <a href="terms.php" class="text-decoration-none">Terms</a>
                </div>
            </div>
        </div>
    </footer>

    <!-- Bootstrap JS -->
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
    <!-- Feather Icons -->
    <script>
        feather.replace();
    </script>
</body>
</html>