<?php
/**
 * Setup Email Settings in Database
 * Run this once to create the admin_settings table structure for email config
 */

require_once 'config/config.php';
require_once 'classes/Database.php';

$db = Database::getInstance();

echo "Setting up email configuration table...\n";

try {
    // Check if column exists in admin_settings
    $result = $db->query("
        ALTER TABLE admin_settings 
        ADD COLUMN IF NOT EXISTS setting_key VARCHAR(255) NOT NULL DEFAULT '' AFTER id,
        ADD COLUMN IF NOT EXISTS setting_value LONGTEXT AFTER setting_key
    ");
    
    echo "✓ Table structure updated\n";
    
    // Create default settings if they don't exist
    $defaultSettings = [
        'email_mode' => 'smtp',
        'mail_host' => 'smtp.gmail.com',
        'mail_port' => '587',
        'mail_encryption' => 'tls',
        'mail_username' => '',
        'mail_from_email' => '',
        'mail_from_name' => 'Advanced Mobile Info'
    ];
    
    foreach ($defaultSettings as $key => $value) {
        $exists = $db->fetch(
            'SELECT id FROM admin_settings WHERE setting_key = ?',
            [$key]
        );
        
        if (!$exists) {
            $db->insert('admin_settings', [
                'setting_key' => $key,
                'setting_value' => $value,
                'created_at' => date('Y-m-d H:i:s')
            ]);
            echo "✓ Created setting: $key\n";
        }
    }
    
    echo "\n✅ Email configuration setup complete!\n";
    echo "\nNext steps:\n";
    echo "1. Go to Admin Dashboard\n";
    echo "2. Click 'Email Settings'\n";
    echo "3. Enter your Gmail credentials\n";
    echo "4. Get App Password from: https://myaccount.google.com/apppasswords\n";
    echo "5. Click 'Send Test Email' to verify\n";
    
} catch (Exception $e) {
    echo "❌ Error: " . $e->getMessage() . "\n";
}
?>
