<?php
/**
 * Test OTP Email Sending on Razorhost
 * Run this script to verify OTP emails are being sent correctly
 */

session_start();
require_once 'config/config.php';
require_once 'classes/Database.php';
require_once 'classes/OTPManager.php';

$db = Database::getInstance();
$message = '';
$message_type = '';

// Get test email from form or use default
$testEmail = $_POST['test_email'] ?? 's26118152@gmail.com';
$testName = $_POST['test_name'] ?? 'Test User';

?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Test OTP Email Sending - Razorhost</title>
    <style>
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }
        
        body {
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            min-height: 100vh;
            display: flex;
            justify-content: center;
            align-items: center;
            padding: 20px;
        }
        
        .container {
            background: white;
            border-radius: 15px;
            box-shadow: 0 10px 40px rgba(0,0,0,0.2);
            max-width: 600px;
            width: 100%;
            padding: 40px;
        }
        
        .header {
            text-align: center;
            margin-bottom: 30px;
        }
        
        .header h1 {
            color: #333;
            margin-bottom: 10px;
            font-size: 28px;
        }
        
        .header p {
            color: #666;
            font-size: 14px;
        }
        
        .form-group {
            margin-bottom: 20px;
        }
        
        .form-group label {
            display: block;
            margin-bottom: 8px;
            color: #333;
            font-weight: 600;
            font-size: 14px;
        }
        
        .form-group input {
            width: 100%;
            padding: 12px 15px;
            border: 2px solid #e0e7ff;
            border-radius: 8px;
            font-size: 14px;
            transition: all 0.3s ease;
        }
        
        .form-group input:focus {
            outline: none;
            border-color: #667eea;
            box-shadow: 0 0 0 3px rgba(102, 126, 234, 0.1);
        }
        
        .btn {
            width: 100%;
            padding: 12px;
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            color: white;
            border: none;
            border-radius: 8px;
            font-weight: 600;
            cursor: pointer;
            transition: all 0.3s ease;
            font-size: 16px;
            margin-top: 20px;
        }
        
        .btn:hover {
            transform: translateY(-2px);
            box-shadow: 0 10px 30px rgba(102, 126, 234, 0.4);
        }
        
        .alert {
            padding: 15px;
            border-radius: 8px;
            margin-bottom: 20px;
            border-left: 4px solid;
        }
        
        .alert-success {
            background: #d4edda;
            color: #155724;
            border-left-color: #28a745;
        }
        
        .alert-danger {
            background: #f8d7da;
            color: #721c24;
            border-left-color: #f5222d;
        }
        
        .alert-info {
            background: #d1ecf1;
            color: #0c5460;
            border-left-color: #17a2b8;
        }
        
        .info-box {
            background: #f8f9fa;
            border: 1px solid #e0e7ff;
            border-radius: 8px;
            padding: 15px;
            margin: 20px 0;
            font-size: 14px;
            line-height: 1.6;
        }
        
        .info-box strong {
            color: #667eea;
        }
        
        .status-box {
            background: #f0f4ff;
            border: 1px solid #667eea;
            border-radius: 8px;
            padding: 15px;
            margin: 20px 0;
            font-family: 'Courier New', monospace;
            font-size: 12px;
        }
        
        .status-box h3 {
            color: #667eea;
            margin-bottom: 10px;
            font-size: 14px;
        }
        
        .status-line {
            margin: 8px 0;
            color: #666;
        }
        
        .status-line.success {
            color: #28a745;
        }
        
        .status-line.error {
            color: #f5222d;
        }
    </style>
</head>
<body>
    <div class="container">
        <div class="header">
            <h1>🔐 Test OTP Email Sending</h1>
            <p>Razorhost Mail Relay Configuration</p>
        </div>
        
        <?php if ($_SERVER['REQUEST_METHOD'] === 'POST'): ?>
            <?php
                // Test OTP generation and sending
                try {
                    $otpManager = new OTPManager($db);
                    $result = $otpManager->generateAndSendOTP($testEmail, $testName);
                    
                    if ($result['success']) {
                        $message = '✅ ' . $result['message'];
                        $message_type = 'success';
                        
                        // Get the OTP from database for testing
                        $otpRecord = $db->fetch(
                            'SELECT otp, expires_at FROM email_otps WHERE email = ? ORDER BY created_at DESC LIMIT 1',
                            [$testEmail]
                        );
                    } else {
                        $message = '❌ ' . $result['message'];
                        $message_type = 'danger';
                    }
                } catch (Exception $e) {
                    $message = '❌ Error: ' . $e->getMessage();
                    $message_type = 'danger';
                }
            ?>
            
            <div class="alert alert-<?php echo $message_type; ?>">
                <?php echo $message; ?>
            </div>
            
            <?php if ($result['success'] && isset($otpRecord)): ?>
                <div class="status-box">
                    <h3>📊 OTP Details</h3>
                    <div class="status-line"><strong>Email:</strong> <?php echo htmlspecialchars($testEmail); ?></div>
                    <div class="status-line"><strong>OTP Code:</strong> <?php echo htmlspecialchars($otpRecord['otp']); ?></div>
                    <div class="status-line"><strong>Expires At:</strong> <?php echo htmlspecialchars($otpRecord['expires_at']); ?></div>
                    <div class="status-line"><strong>Expires In:</strong> 15 minutes</div>
                </div>
                
                <div class="info-box">
                    <strong>✓ Next Steps:</strong><br>
                    1. Check your email inbox (and spam/promotions folder)<br>
                    2. You should receive the OTP email within 1-5 seconds<br>
                    3. Use the OTP code shown above to test verification<br>
                    4. Check server logs if email is not received
                </div>
            <?php endif; ?>
        <?php endif; ?>
        
        <div class="info-box">
            <strong>📧 Razorhost Configuration:</strong><br>
            • Mode: Mail Relay<br>
            • Host: localhost<br>
            • Port: 25 (No SSL)<br>
            • Auth: Not required<br>
            • From Email: <?php echo htmlspecialchars($MAIL_FROM_EMAIL); ?>
        </div>
        
        <form method="POST">
            <div class="form-group">
                <label for="test_email">Test Email Address</label>
                <input 
                    type="email" 
                    id="test_email" 
                    name="test_email" 
                    value="<?php echo htmlspecialchars($testEmail); ?>" 
                    placeholder="user@example.com"
                    required
                >
            </div>
            
            <div class="form-group">
                <label for="test_name">User Name</label>
                <input 
                    type="text" 
                    id="test_name" 
                    name="test_name" 
                    value="<?php echo htmlspecialchars($testName); ?>" 
                    placeholder="John Doe"
                    required
                >
            </div>
            
            <button type="submit" class="btn">Send Test OTP Email →</button>
        </form>
        
        <div class="info-box" style="margin-top: 30px;">
            <strong>⚠️ Troubleshooting:</strong><br>
            • If email not received: Check spam/promotions folder<br>
            • If still missing: Check Razorhost mail queue<br>
            • Enable debug mode: Check error logs at /error_log<br>
            • Test with different email address<br>
            • Contact Razorhost support if mail relay is blocked
        </div>
    </div>
</body>
</html>
