<?php
$totalUsers = $db->fetch('SELECT COUNT(*) AS total FROM users WHERE role="user"')['total'] ?? 0;
$totalSearches = $db->fetch('SELECT COUNT(*) AS total FROM search_logs')['total'] ?? 0;
$totalRevenue = $db->fetch('SELECT SUM(cost) AS total FROM search_logs WHERE status="success"')['total'] ?? 0;
$recentUsers = $db->fetchAll('SELECT name, email, role, is_active FROM users ORDER BY id DESC LIMIT 5');
?>
<h3>Welcome, <?php echo htmlspecialchars($currentUser['name']); ?> 👋</h3>
<p class="text-muted">System Overview</p>

<div class="row mb-4">
    <div class="col-md-4"><div class="stats-card"><h6>Total Users</h6><h3><?= $totalUsers ?></h3></div></div>
    <div class="col-md-4"><div class="stats-card"><h6>Total Searches</h6><h3><?= $totalSearches ?></h3></div></div>
    <div class="col-md-4"><div class="stats-card"><h6>Total Revenue</h6><h3>₹<?= number_format($totalRevenue,2) ?></h3></div></div>
</div>

<div class="card p-4">
    <h5>Recent Users</h5>
    <table class="table table-striped mt-3">
        <thead><tr><th>Name</th><th>Email</th><th>Role</th><th>Status</th></tr></thead>
        <tbody>
        <?php foreach ($recentUsers as $user): ?>
            <tr>
                <td><?= htmlspecialchars($user['name']) ?></td>
                <td><?= htmlspecialchars($user['email']) ?></td>
                <td><?= ucfirst($user['role']) ?></td>
                <td><span class="badge bg-<?= $user['is_active']?'success':'danger' ?>"><?= $user['is_active']?'Active':'Inactive' ?></span></td>
            </tr>
        <?php endforeach; ?>
        </tbody>
    </table>
</div>
