<?php
$logs = $db->fetchAll('SELECT a.*, u.name FROM audit_logs a 
                       LEFT JOIN users u ON a.user_id = u.id 
                       ORDER BY a.id DESC LIMIT 20');
?>
<h4>System Logs</h4>
<p class="text-muted">Recent login, logout, and system activities</p>
<div class="card p-3">
    <table class="table table-striped">
        <thead>
        <tr><th>User</th><th>Action</th><th>Details</th><th>Date</th></tr>
        </thead>
        <tbody>
        <?php foreach ($logs as $log): ?>
            <tr>
                <td><?php echo htmlspecialchars($log['name'] ?? 'Unknown'); ?></td>
                <td><span class="badge bg-info text-dark"><?php echo htmlspecialchars($log['action']); ?></span></td>
                <td><?php echo htmlspecialchars($log['details']); ?></td>
                <td><?php echo date('d M Y H:i', strtotime($log['created_at'])); ?></td>
            </tr>
        <?php endforeach; ?>
        </tbody>
    </table>
</div>
