<?php
require_once __DIR__ . '/../../classes/Database.php';
$db = Database::getInstance();

/* -----------------------------
   HANDLE ADMIN REPLY
------------------------------ */
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['ticket_id'], $_POST['message'])) {
    $ticket = intval($_POST['ticket_id']);
    $msg = trim($_POST['message']);

    if ($msg !== "") {
        $db->insert("support_messages", [
            "ticket_id" => $ticket,
            "sender_id" => 1, // admin
            "receiver_id" => 0,
            "message" => $msg,
            "created_at" => date("Y-m-d H:i:s")
        ]);
    }
}

/* -----------------------------
   DELETE MESSAGE (ADMIN ONLY)
------------------------------ */
if (isset($_GET['delete']) && is_numeric($_GET['delete'])) {
    $db->delete("support_messages", "id = :id", [":id" => $_GET['delete']]);
}

/* -----------------------------
   FETCH TICKETS
------------------------------ */
$tickets = $db->fetchAll("
   SELECT s.*, u.name AS username
   FROM support_tickets s
   JOIN users u ON u.id = s.user_id
   ORDER BY s.created_at DESC
");

// Get selected chat
$openTicket = $_GET['chat'] ?? ($tickets[0]['id'] ?? null);

// Load messages for opened ticket
$messages = [];
if ($openTicket) {
    $messages = $db->fetchAll("
        SELECT * FROM support_messages
        WHERE ticket_id = :t
        ORDER BY created_at ASC
    ", [":t" => $openTicket]);
}
?>

<style>
.chat-wrapper {
    display: flex;
    height: 80vh;
    gap: 15px;
}

.chat-left {
    width: 28%;
    background: #fff;
    border-radius: 12px;
    padding: 15px;
    box-shadow: 0 4px 12px rgba(0,0,0,0.1);
    overflow-y: auto;
}

.chat-right {
    width: 72%;
    background: #fff;
    border-radius: 12px;
    padding: 0;
    box-shadow: 0 4px 12px rgba(0,0,0,0.1);
    display: flex;
    flex-direction: column;
}

.chat-header {
    padding: 15px;
    border-bottom: 1px solid #eee;
    font-weight: bold;
}

.chat-body {
    flex: 1;
    overflow-y: auto;
    padding: 20px;
    background: #f5f5f5;
}

.msg {
    max-width: 60%;
    padding: 10px 12px;
    margin-bottom: 12px;
    border-radius: 10px;
    position: relative;
}

.msg.admin {
    background: #007aff;
    color: #fff;
    margin-left: auto;
}

.msg.user {
    background: #e9e9eb;
    color: #000;
}

.delete-icon {
    position: absolute;
    top: -4px;
    right: -4px;
    font-size: 12px;
    color: red;
    cursor: pointer;
}

.chat-footer {
    padding: 12px;
    border-top: 1px solid #ddd;
    display: flex;
    gap: 10px;
}
</style>

<h4 class="mb-3">Support — Admin Chat </h4>

<div class="chat-wrapper">

    <!-- LEFT SIDE: TICKET LIST -->
    <div class="chat-left">

        <h6 class="mb-3">Tickets</h6>

        <?php foreach ($tickets as $t): ?>
        <a href="?page=support&chat=<?= $t['id'] ?>" 
           class="d-block p-2 mb-2 rounded <?= ($openTicket == $t['id']) ? 'bg-primary text-white' : 'bg-light' ?>"
           style="text-decoration:none">
            <strong><?= htmlspecialchars($t['title']) ?></strong><br>
            <small><?= htmlspecialchars($t['username']) ?> • <?= date("M d, H:i", strtotime($t['created_at'])) ?></small>
        </a>
        <?php endforeach; ?>

    </div>

    <!-- RIGHT SIDE: CHAT WINDOW -->
    <div class="chat-right">

        <?php if (!$openTicket): ?>
            <div class="p-4">Select a ticket to start chatting</div>
        <?php else: ?>

            <div class="chat-header">
                Ticket #<?= $openTicket ?>
            </div>

            <div class="chat-body">

                <?php foreach ($messages as $m): ?>
                    <div class="msg <?= ($m['sender_id'] == 1 ? 'admin' : 'user') ?>">
                        <?= nl2br(htmlspecialchars($m['message'])) ?>
                        <br>
                        <small><?= date("M d, H:i", strtotime($m['created_at'])) ?></small>

                        <!-- DELETE for admin only -->
                        <a href="?page=support&chat=<?= $openTicket ?>&delete=<?= $m['id'] ?>"
                           class="delete-icon"
                           onclick="return confirm('Delete this message?')">✖</a>
                    </div>
                <?php endforeach; ?>

            </div>

            <!-- CHAT INPUT -->
            <form method="post" class="chat-footer">
                <input type="hidden" name="ticket_id" value="<?= $openTicket ?>">
                <input type="text" name="message" class="form-control" placeholder="Type a reply..." required>
                <button class="btn btn-primary">Send</button>
            </form>

        <?php endif; ?>

    </div>
</div>
