<?php
require_once __DIR__ . '/../../classes/Database.php';
$db = Database::getInstance();

// Fetch all users
$users = $db->fetchAll("SELECT * FROM users ORDER BY id DESC");
?>

<div class="container-fluid">
    <h4 class="mb-4">👤 User Management</h4>

    <div class="card shadow-sm">
        <div class="card-body table-responsive">

            <table class="table table-bordered align-middle">
                <thead class="table-light">
                    <tr>
                        <th>ID</th>
                        <th>User</th>
                        <th>Email</th>
                        <th>Active</th>
                        <th>Action</th>
                    </tr>
                </thead>

                <tbody>
                <?php foreach ($users as $u): ?>
                    <tr>
                        <td><?= $u['id'] ?></td>

                        <td><?= htmlspecialchars($u['name']) ?></td>

                        <td><?= htmlspecialchars($u['email']) ?></td>

                        <!-- ACTIVE / DISABLE USER ONLY -->
                        <td>
                            <input type="checkbox"
                                   class="toggle-control"
                                   data-id="<?= $u['id'] ?>"
                                   data-field="is_active"
                                   <?= $u['is_active'] ? "checked" : "" ?>>
                        </td>

                        <!-- DELETE ONLY -->
                        <td>
                            <a href="dashboard.php?page=users&delete_user=<?= $u['id'] ?>"
   onclick="return confirm('Delete this user?')"
   class="btn btn-danger btn-sm">
   Delete
</a>


                        </td>
                    </tr>
                <?php endforeach; ?>
                </tbody>

            </table>

        </div>
    </div>
</div>

<!-- AJAX SCRIPT -->
<script>
document.querySelectorAll(".toggle-control").forEach(el => {
    el.addEventListener("change", function () {
        let id    = this.dataset.id;
        let field = this.dataset.field;
        let value = this.checked ? 1 : 0;

        fetch("ajax_update_user.php", {
            method: "POST",
            headers: { "Content-Type": "application/x-www-form-urlencoded" },
            body: `id=${id}&field=${field}&value=${value}`
        })
        .then(r => r.text())
        .then(res => console.log(res));
    });
});
</script>
