<?php
require_once 'config/config.php';
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Terms and Conditions - <?php echo APP_NAME; ?></title>
    
    <!-- Bootstrap CSS -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <!-- Feather Icons -->
    <script src="https://unpkg.com/feather-icons"></script>
    
    <style>
        :root {
            --primary-color: #007AFF;
            --secondary-color: #F2F2F7;
            --text-color: #1C1C1E;
            --light-gray: #F5F6F8;
            --border-color: #E5E5EA;
            --shadow-color: rgba(0, 0, 0, 0.1);
        }
        
        * {
            font-family: -apple-system, BlinkMacSystemFont, "Segoe UI", Roboto, "Helvetica Neue", Arial, sans-serif;
        }
        
        body {
            background: var(--light-gray);
            color: var(--text-color);
        }
        
        .navbar {
            background: rgba(255, 255, 255, 0.95);
            backdrop-filter: blur(10px);
            border-bottom: 1px solid var(--border-color);
        }
        
        .navbar-brand {
            font-weight: 700;
            color: var(--text-color) !important;
        }
        
        .content-container {
            background: white;
            border-radius: 16px;
            box-shadow: 0 4px 20px var(--shadow-color);
            padding: 2rem;
            margin: 2rem 0;
        }
        
        .content-header {
            text-align: center;
            margin-bottom: 2rem;
            padding-bottom: 1.5rem;
            border-bottom: 1px solid var(--border-color);
        }
        
        .content-title {
            font-size: 2.5rem;
            font-weight: 700;
            background: linear-gradient(135deg, #007AFF 0%, #0056CC 100%);
            -webkit-background-clip: text;
            -webkit-text-fill-color: transparent;
            background-clip: text;
            margin-bottom: 0.5rem;
        }
        
        .content-subtitle {
            color: #6C757D;
            font-size: 1.1rem;
        }
        
        .section-title {
            font-size: 1.5rem;
            font-weight: 600;
            color: var(--primary-color);
            margin: 2rem 0 1rem 0;
        }
        
        .section-content {
            line-height: 1.6;
            margin-bottom: 1.5rem;
        }
        
        .footer {
            background: rgba(255, 255, 255, 0.95);
            backdrop-filter: blur(10px);
            border-top: 1px solid var(--border-color);
            padding: 2rem 0;
            margin-top: 4rem;
        }
    </style>
</head>
<body>
    <!-- Navigation -->
    <nav class="navbar navbar-expand-lg fixed-top">
        <div class="container">
            <a class="navbar-brand" href="index.php">
                <i data-feather="smartphone" class="me-2"></i>
                <?php echo APP_NAME; ?>
            </a>
            <button class="navbar-toggler" type="button" data-bs-toggle="collapse" data-bs-target="#navbarNav">
                <span class="navbar-toggler-icon"></span>
            </button>
            <div class="collapse navbar-collapse" id="navbarNav">
                <ul class="navbar-nav ms-auto">
                    <li class="nav-item">
                        <a class="nav-link" href="index.php">Home</a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link" href="login.php">Login</a>
                    </li>
                    <?php if (ALLOW_REGISTRATION): ?>
                    <li class="nav-item">
                        <a class="nav-link" href="register.php">Register</a>
                    </li>
                    <?php endif; ?>
                </ul>
            </div>
        </div>
    </nav>

    <!-- Main Content -->
    <div class="container" style="margin-top: 100px;">
        <div class="content-container">
            <div class="content-header">
                <h1 class="content-title">Terms and Conditions</h1>
                <p class="content-subtitle">Last updated: January 1, 2024</p>
            </div>
            
            <h2 class="section-title">1. Acceptance of Terms</h2>
            <div class="section-content">
                By accessing and using <?php echo APP_NAME; ?>, you agree to be bound by these Terms and Conditions. If you disagree with any part of the terms, you may not access our services.
            </div>
            
            <h2 class="section-title">2. Use License</h2>
            <div class="section-content">
                <ul>
                    <li>Permission is granted to temporarily download one copy of the materials for personal, non-commercial transitory viewing only.</li>
                    <li>This is the grant of a license, not a transfer of title.</li>
                    <li>Under this license you may not modify or copy the materials.</li>
                    <li>This license shall automatically terminate if you violate any of these restrictions.</li>
                </ul>
            </div>
            
            <h2 class="section-title">3. Disclaimer</h2>
            <div class="section-content">
                The materials on <?php echo APP_NAME; ?> are provided on an 'as is' basis. <?php echo APP_NAME; ?> makes no warranties, expressed or implied, and hereby disclaims and negates all other warranties including, without limitation, implied warranties or conditions of merchantability, fitness for a particular purpose, or non-infringement of intellectual property or other violation of rights.
            </div>
            
            <h2 class="section-title">4. Limitations</h2>
            <div class="section-content">
                In no event shall <?php echo APP_NAME; ?> or its suppliers be liable for any damages (including, without limitation, damages for loss of data or profit, or due to business interruption) arising out of the use or inability to use the materials on <?php echo APP_NAME; ?>, even if <?php echo APP_NAME; ?> or a <?php echo APP_NAME; ?> authorized representative has been notified orally or in writing of the possibility of such damage.
            </div>
            
            <h2 class="section-title">5. Privacy Policy</h2>
            <div class="section-content">
                Your privacy is important to us. Our Privacy Policy explains how we collect, use, and protect your personal information. By using our services, you agree to the collection and use of information in accordance with our Privacy Policy.
            </div>
            
            <h2 class="section-title">6. Governing Law</h2>
            <div class="section-content">
                These terms and conditions are governed by and construed in accordance with the laws of India and you irrevocably submit to the exclusive jurisdiction of the courts in that State or location.
            </div>
            
            <h2 class="section-title">7. Changes to Terms</h2>
            <div class="section-content">
                <?php echo APP_NAME; ?> reserves the right to revise these terms of service for its website at any time without notice. By using this website you are agreeing to be bound by the then current version of these terms of service.
            </div>
        </div>
    </div>

    <!-- Footer -->
    <footer class="footer">
        <div class="container">
            <div class="row">
                <div class="col-md-6 text-center text-md-start">
                    <p class="mb-0">&copy; 2024 <?php echo APP_NAME; ?>. All rights reserved.</p>
                </div>
                <div class="col-md-6 text-center text-md-end">
                    <a href="privacy.php" class="text-decoration-none me-3">Privacy Policy</a>
                    <a href="contact.php" class="text-decoration-none me-3">Support</a>
                    <a href="terms.php" class="text-decoration-none">Terms</a>
                </div>
            </div>
        </div>
    </footer>

    <!-- Bootstrap JS -->
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
    <!-- Feather Icons -->
    <script>
        feather.replace();
    </script>
</body>
</html>