<?php
require_once '../config/config.php';
require_once '../classes/Database.php';
require_once '../classes/Auth.php';
require_once '../classes/User.php';

$db = Database::getInstance(); 
$auth = new Auth($db);

if (!$auth->isLoggedIn()) {
    header('Location: ../login.php');
    exit();
}

$currentUser = $auth->getCurrentUser();
$message = '';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $title = trim($_POST['title'] ?? '');
    $body  = trim($_POST['body'] ?? '');

    if ($title !== '' && $body !== '') {

        $sql = "INSERT INTO support_tickets (user_id, title, body, status, created_at)
                VALUES (:uid, :title, :body, 'open', NOW())";

        $stmt = $db->prepare($sql);
        $stmt->execute([
            ':uid'   => $currentUser['id'],
            ':title' => $title,
            ':body'  => $body
        ]);

        $message = 'Ticket submitted successfully!';
    } else {
        $message = 'Please fill all fields.';
    }
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="UTF-8">
<title>Support - <?php echo APP_NAME; ?></title>
<meta name="viewport" content="width=device-width, initial-scale=1">

<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">

<style>
body {
    background: #f2f2f7;
    font-family: -apple-system, BlinkMacSystemFont, Segoe UI, Roboto, sans-serif;
}
.container {
    max-width: 650px;
    margin-top: 50px;
}
.card {
    border-radius: 16px;
    padding: 25px;
    box-shadow: 0 4px 16px rgba(0,0,0,0.10);
}
.btn-primary {
    background: #007aff;
    border: none;
    border-radius: 10px;
}
.btn-secondary {
    border-radius: 10px;
}
</style>
</head>

<body>

<div class="container">
    <div class="card">
        <h4 class="mb-3">💬 Support</h4>

        <?php if ($message): ?>
            <div class="alert alert-info py-2">
                <?php echo htmlspecialchars($message); ?>
            </div>
        <?php endif; ?>

        <form method="post">
            <div class="mb-3">
                <label class="form-label fw-semibold">Title</label>
                <input type="text" name="title" class="form-control" placeholder="Enter a short title" required>
            </div>

            <div class="mb-3">
                <label class="form-label fw-semibold">Message</label>
                <textarea name="body" rows="5" class="form-control" placeholder="Describe your issue..." required></textarea>
            </div>

            <div class="text-end">
                <a href="dashboard.php" class="btn btn-secondary">Back</a>
                <button type="submit" class="btn btn-primary">Submit Ticket</button>
            </div>
        </form>
    </div>
</div>

</body>
</html>
