<?php
/**
 * Check current session status
 */

if (session_status() === PHP_SESSION_NONE) {
    session_start();
}

header('Content-Type: application/json');

$isLoggedIn = !empty($_SESSION['user_id']);
$isAdmin = isset($_SESSION['user_role']) && $_SESSION['user_role'] === 'admin';

$response = [
    'user_id' => $_SESSION['user_id'] ?? null,
    'user_email' => $_SESSION['user_email'] ?? null,
    'user_role' => $_SESSION['user_role'] ?? null,
    'is_admin' => $isAdmin,
    'is_logged_in' => $isLoggedIn,
    'session_active' => session_status() === PHP_SESSION_ACTIVE,
    'can_access' => $isLoggedIn && $isAdmin
];

echo json_encode($response);
?>
