<?php
require_once 'config/config.php';
require_once 'classes/Database.php';
require_once 'classes/Auth.php';

$db = Database::getInstance();
$auth = new Auth($db);

if ($auth->isLoggedIn()) {
    $auth->redirectBasedOnRole();
}
?>
<!DOCTYPE html>
<html lang="en" data-theme="dark">
<head>
    <meta charset="utf-8" />
    <meta name="viewport" content="width=device-width,initial-scale=1" />
    <title><?= htmlspecialchars(APP_NAME) ?> — Fast • Secure • Beautiful</title>

    <!-- Bootstrap CSS -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">

    <!-- Feather Icons -->
    <script src="https://unpkg.com/feather-icons"></script>

    <style>
        /* -------------------------
           Theme variables (Mixed Dark)
           ------------------------- */
        :root {
            --bg-900: #05060a;
            --bg-800: #0b1020;
            --panel: rgba(255,255,255,0.06);
            --glass-blur: 10px;
            --accent-1: linear-gradient(135deg,#007AFF 0%, #00B0FF 100%);
            --accent-color: #00b0ff;
            --muted: #98a1ad;
            --text: #e6eef8;
            --neon-shadow: 0 6px 24px rgba(0,176,255,0.14), 0 0 18px rgba(0,176,255,0.06);
            --card-radius: 16px;
        }

        /* base */
        html,body { height:100%; margin:0; padding:0; font-family:Inter, system-ui, -apple-system, "Segoe UI", Roboto, "Helvetica Neue", Arial; background: radial-gradient(1200px 600px at 10% 10%, rgba(0,112,255,0.06), transparent), linear-gradient(180deg,var(--bg-900), var(--bg-800)); color:var(--text); -webkit-font-smoothing:antialiased; -moz-osx-font-smoothing:grayscale; }

        /* NAV */
        .navbar { background: transparent; backdrop-filter: blur(4px); }
        .navbar .navbar-brand { color:var(--text); display:flex; align-items:center; gap:.5rem; font-weight:700; }
        .navbar .nav-link { color:var(--muted); transition: color .18s ease; }
        .navbar .nav-link:hover { color:var(--text); }
        .navbar-toggler { border: 1px solid rgba(255,255,255,0.04); }
        .navbar-toggler-icon {
            background-image: url("data:image/svg+xml,%3csvg xmlns='http://www.w3.org/2000/svg' viewBox='0 0 30 30'%3e%3cpath stroke='%23cfeeff' stroke-width='2' stroke-linecap='round' stroke-miterlimit='10' d='M4 7h22M4 15h22M4 23h22'/%3e%3c/svg%3e");
        }

        /* HERO */
        .hero-section { min-height: 92vh; display:flex; align-items:center; justify-content:center; padding-top:82px; position:relative; overflow:hidden; }
        .hero-content { text-align:center; max-width:760px; padding:2.2rem 1.2rem; z-index:2; }

        .hero-title {
            font-size:3rem; font-weight:800; margin:0 0 .5rem; letter-spacing:-0.02em;
            background-image: var(--accent-1);
            -webkit-background-clip:text; background-clip:text; color:transparent;
        }
        .hero-subtitle { color:var(--muted); margin-bottom:1.6rem; font-size:1.05rem; }

        /* Buttons neon */
        .btn-neon {
            border-radius:12px;
            box-shadow: var(--neon-shadow);
            background: linear-gradient(90deg, rgba(0,176,255,0.14), rgba(0,122,255,0.06));
            border:1px solid rgba(0,176,255,0.18);
            color:var(--text);
            transition: transform .15s ease, box-shadow .15s ease;
        }
        .btn-neon:hover { transform: translateY(-3px); box-shadow: 0 12px 44px rgba(0,176,255,0.18), 0 0 30px rgba(0,176,255,0.08); }

        .btn-outline-neon {
            color: var(--text);
            border: 1px solid rgba(255,255,255,0.06);
            background: linear-gradient(180deg, rgba(255,255,255,0.02), transparent);
            box-shadow: 0 6px 18px rgba(2,6,23,0.6);
            border-radius:12px;
        }

        /* FEATURE CARDS - Glassmorphism */
        .feature-card {
            background: linear-gradient(180deg, rgba(255,255,255,0.03), rgba(255,255,255,0.02));
            border: 1px solid rgba(255,255,255,0.04);
            backdrop-filter: blur(var(--glass-blur));
            -webkit-backdrop-filter: blur(var(--glass-blur));
            border-radius: var(--card-radius);
            padding:1.6rem;
            text-align:center;
            transition: transform .25s cubic-bezier(.2,.9,.2,1), box-shadow .25s ease;
            box-shadow: 0 6px 24px rgba(2,8,20,0.45);
        }
        .feature-card:hover { transform: translateY(-8px); box-shadow: 0 20px 60px rgba(2,8,20,0.5); }

        .feature-icon {
            width:56px; height:56px; border-radius:12px; display:flex; align-items:center; justify-content:center;
            background: linear-gradient(135deg, rgba(0,176,255,0.15), rgba(0,122,255,0.06));
            box-shadow: 0 8px 30px rgba(0,176,255,0.06);
            margin: 0 auto 12px;
            color:var(--text);
            font-size:20px;
        }

        .feature-card h5 { color:var(--text); font-size:1.05rem; margin-bottom:.4rem; }
        .feature-card p { color:var(--muted); margin-bottom:0; font-size:.9rem; }

        /* Floating shapes - soft */
        .floating-shapes { position:absolute; inset:0; z-index:1; opacity:.9; pointer-events:none; }
        .shape { position:absolute; border-radius:50%; filter: blur(40px); opacity:.24; mix-blend-mode:screen; }
        .shape.a { width:420px;height:420px; background: radial-gradient(circle at 30% 30%, rgba(0,176,255,0.12), transparent 40%); left:-8%; top:-10%; transform:translateZ(0); }
        .shape.b { width:260px;height:260px; background: radial-gradient(circle at 70% 30%, rgba(0,122,255,0.10), transparent 40%); right:-6%; top:14%; }
        .shape.c { width:160px;height:160px; background: radial-gradient(circle at 40% 60%, rgba(96, 47, 255,0.06), transparent 40%); left:12%; bottom:6%; }

        /* FOOTER */
        footer.footer { border-top:1px solid rgba(255,255,255,0.02); background: transparent; padding-top:1rem; padding-bottom:1rem; color:var(--muted); }

        /* RESPONSIVE */
        @media (max-width:768px) {
            .hero-title{ font-size:2.2rem; }
            .feature-icon{ width:50px; height:50px; }
            .hero-section{ padding-top:94px; min-height:auto; }
        }

        /* PRELOADER */
        .preloader {
            position:fixed; inset:0; display:flex; align-items:center; justify-content:center;
            background: linear-gradient(180deg, rgba(2,6,23,0.85), rgba(2,6,23,0.92));
            z-index:9999; transition: opacity .45s ease, visibility .45s ease;
        }
        .preloader.hidden { opacity:0; visibility:hidden; pointer-events:none; }

        .loader-wrap { text-align:center; color:var(--text); }
        .loader {
            width:72px; height:72px; border-radius:50%;
            border:6px solid rgba(255,255,255,0.06);
            border-top-color: var(--accent-color);
            animation: spin 1s linear infinite;
            margin: 0 auto 14px;
            box-shadow: 0 8px 32px rgba(0,176,255,0.08);
        }
        @keyframes spin { to { transform: rotate(360deg); } }

        .loader-title { font-weight:700; letter-spacing:.02em; margin-bottom:6px; }
        .loader-sub { color:var(--muted); font-size:.92rem; }

        /* small helpers */
        .glass-btn { border-radius:12px; padding:.65rem 1rem; font-weight:600; }
        .muted { color:var(--muted); }

    </style>
</head>
<body>

    <!-- PRELOADER -->
    <div id="preloader" class="preloader" role="status" aria-label="Loading">
        <div class="loader-wrap">
            <div class="loader" aria-hidden="true"></div>
            <div class="loader-title"><?= htmlspecialchars(APP_NAME) ?></div>
            <div class="loader-sub">Preparing your secure session…</div>
        </div>
    </div>

    <!-- NAVBAR -->
    <nav class="navbar navbar-expand-lg fixed-top px-3" aria-label="Primary navigation">
        <div class="container">
            <a class="navbar-brand" href="#" aria-current="page">
                <i data-feather="smartphone" style="vertical-align:middle"></i>
                <span style="margin-left:.45rem; font-weight:700"><?= htmlspecialchars(APP_NAME) ?></span>
            </a>

            <button class="navbar-toggler ms-auto" type="button" data-bs-toggle="collapse" data-bs-target="#navMenu" aria-controls="navMenu" aria-expanded="false" aria-label="Toggle navigation">
                <span class="navbar-toggler-icon"></span>
            </button>

            <div class="collapse navbar-collapse" id="navMenu">
                <ul class="navbar-nav ms-auto align-items-lg-center">
                    <li class="nav-item"><a class="nav-link" href="login.php">Login</a></li>

                    <?php if (defined('ALLOW_REGISTRATION') && ALLOW_REGISTRATION): ?>
                    <li class="nav-item"><a class="nav-link" href="register.php">Register</a></li>
                    <?php endif; ?>

                    <li class="nav-item"><a class="nav-link" href="contact.php">Contact Admin</a></li>
                </ul>
            </div>
        </div>
    </nav>

    <!-- HERO -->
    <main class="hero-section" role="main">
        <div class="floating-shapes" aria-hidden="true">
            <div class="shape a"></div>
            <div class="shape b"></div>
            <div class="shape c"></div>
        </div>

        <div class="hero-content container">
            <h1 class="hero-title">Advanced Mobile Info System</h1>
            <p class="hero-subtitle">Fast • Secure • Beautiful — now darker, sleeker, and glowing.</p>

            <div class="d-flex flex-wrap justify-content-center gap-3 mb-4">
                <a href="login.php" class="btn btn-neon glass-btn d-inline-flex align-items-center">
                    <i data-feather="log-in" class="me-2" style="filter:drop-shadow(0 6px 12px rgba(0,176,255,0.08))"></i> Login
                </a>

                <?php if (defined('ALLOW_REGISTRATION') && ALLOW_REGISTRATION): ?>
                <a href="register.php" class="btn btn-outline-neon glass-btn d-inline-flex align-items-center">
                    <i data-feather="user-plus" class="me-2"></i> Register
                </a>
                <?php endif; ?>
            </div>

            <!-- FEATURES -->
            <div class="row g-4 mt-3 justify-content-center">
                <div class="col-12 col-md-4">
                    <div class="feature-card">
                        <div class="feature-icon"><i data-feather="search"></i></div>
                        <h5>Mobile Lookup</h5>
                        <p class="muted small">Instant mobile number details with accurate data and fast responses.</p>
                    </div>
                </div>

                <div class="col-12 col-md-4">
                    <div class="feature-card">
                        <div class="feature-icon"><i data-feather="credit-card"></i></div>
                        <h5>Aadhaar Lookup</h5>
                        <p class="muted small">Secure Aadhaar verification with encryption and audit logs.</p>
                    </div>
                </div>

                <div class="col-12 col-md-4">
                    <div class="feature-card">
                        <div class="feature-icon"><i data-feather="dollar-sign"></i></div>
                        <h5>Wallet Credits</h5>
                        <p class="muted small">Recharge system with instant balance updates and transaction history.</p>
                    </div>
                </div>
            </div>
        </div>
    </main>

    <!-- FOOTER -->
    <footer class="footer">
        <div class="container text-center small">
            &copy; <?= date("Y") ?> <?= htmlspecialchars(APP_NAME) ?> — All rights reserved.
        </div>
    </footer>

    <!-- SCRIPTS -->
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>

    <script>
        // feather icons
        feather.replace();

        // Preloader hide logic:
        (function() {
            const preloader = document.getElementById('preloader');

            // Ensure preloader visible for at least 600ms for smoothness
            const minTime = 600;
            const start = Date.now();

            function hideLoader() {
                const elapsed = Date.now() - start;
                const wait = Math.max(0, minTime - elapsed);

                setTimeout(() => {
                    preloader.classList.add('hidden');
                }, wait);
            }

            // On DOM ready and window load — hide
            if (document.readyState === 'complete' || document.readyState === 'interactive') {
                // Some resources may still load -> wait for load event to be safe
                window.addEventListener('load', hideLoader);
            } else {
                window.addEventListener('load', hideLoader);
            }

            // Also hide if load doesn't fire (fallback after 3s)
            setTimeout(hideLoader, 3000);
        })();
    </script>

</body>
</html>
