<?php
require 'config/database.php';

$db = Database::getInstance();

echo "<h2>Payment Orders Status</h2>";
$orders = $db->fetchAll('SELECT * FROM payment_orders ORDER BY created_at DESC LIMIT 10');
echo "<table border='1' cellpadding='5'>";
echo "<tr><th>Order ID</th><th>User ID</th><th>Amount</th><th>Status</th><th>Transaction ID</th><th>Created At</th></tr>";
foreach ($orders as $order) {
    echo "<tr>";
    echo "<td>" . htmlspecialchars($order['order_id']) . "</td>";
    echo "<td>" . $order['user_id'] . "</td>";
    echo "<td>₹" . $order['amount'] . "</td>";
    echo "<td><strong>" . $order['status'] . "</strong></td>";
    echo "<td>" . htmlspecialchars($order['transaction_id'] ?? '-') . "</td>";
    echo "<td>" . $order['created_at'] . "</td>";
    echo "</tr>";
}
echo "</table>";

echo "<h2>Payment Class getPendingApprovals() Test</h2>";
require 'classes/Payment.php';
$payment = new Payment();
$pending = $payment->getPendingApprovals(10);
echo "<pre>";
print_r($pending);
echo "</pre>";
?>
