<?php
/**
 * Email Configuration for OTP and Notifications
 * PRODUCTION READY - Configure for your hosting environment
 */

// Set to 'smtp' for SMTP or 'php_mail' for server mail
$EMAIL_MODE = getenv('EMAIL_MODE') ?: 'php_mail';

return [
    // Email sending mode: 'smtp' or 'php_mail'
    'mode' => $EMAIL_MODE,
    
    // Email sender info - MUST be a valid email on the domain
    'from_email' => getenv('MAIL_FROM_EMAIL') ?: 's26118152@gmail.com',
    'from_name' => getenv('MAIL_FROM_NAME') ?: 'Advanced Mobile Info',
    
    // SMTP Configuration (for production setups)
    'smtp_host' => getenv('MAIL_HOST') ?: 'smtp.gmail.com',
    'smtp_port' => getenv('MAIL_PORT') ?: 587,
    'smtp_secure' => getenv('MAIL_ENCRYPTION') ?: 'tls',
    'smtp_username' => getenv('MAIL_USERNAME') ?: 's26118152@gmail.com',
    'smtp_password' => getenv('MAIL_PASSWORD') ?: 'gyiv ebml hzoc otmh',
    'smtp_timeout' => 10,
    
    // OTP Settings (configurable from admin panel)
    'otp_length' => 6,
    'otp_expiry_minutes' => 5,      // Default: OTP valid for 5 minutes
    'otp_max_attempts' => 5         // Maximum verification attempts
];
?>
