-- Create subscription_plans table if not exists
CREATE TABLE IF NOT EXISTS `subscription_plans` (
  `id` int(11) NOT NULL AUTO_INCREMENT PRIMARY KEY,
  `plan_name` varchar(255) NOT NULL,
  `duration_days` int(11) NOT NULL,
  `search_limit` int(11) NOT NULL,
  `price` decimal(10, 2) NOT NULL,
  `description` text,
  `card_color` varchar(7) DEFAULT '#007AFF',
  `is_active` tinyint(1) DEFAULT 1,
  `created_at` timestamp DEFAULT CURRENT_TIMESTAMP,
  `updated_at` timestamp DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP
);

-- Create user_subscriptions table if not exists
CREATE TABLE IF NOT EXISTS `user_subscriptions` (
  `id` int(11) NOT NULL AUTO_INCREMENT PRIMARY KEY,
  `user_id` int(11) NOT NULL,
  `plan_id` int(11) NOT NULL,
  `razorpay_order_id` varchar(255),
  `razorpay_payment_id` varchar(255),
  `razorpay_signature` varchar(255),
  `start_date` datetime NOT NULL,
  `end_date` datetime NOT NULL,
  `status` varchar(50) DEFAULT 'active',
  `payment_status` varchar(50) DEFAULT 'pending',
  `search_used` int(11) DEFAULT 0,
  `created_at` timestamp DEFAULT CURRENT_TIMESTAMP,
  `updated_at` timestamp DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  FOREIGN KEY (`user_id`) REFERENCES `users`(`id`) ON DELETE CASCADE,
  FOREIGN KEY (`plan_id`) REFERENCES `subscription_plans`(`id`) ON DELETE CASCADE
);

-- Create subscription_history table if not exists
CREATE TABLE IF NOT EXISTS `subscription_history` (
  `id` int(11) NOT NULL AUTO_INCREMENT PRIMARY KEY,
  `user_id` int(11) NOT NULL,
  `subscription_id` int(11),
  `action` varchar(100) NOT NULL,
  `old_status` varchar(50),
  `new_status` varchar(50),
  `details` json,
  `created_at` timestamp DEFAULT CURRENT_TIMESTAMP,
  FOREIGN KEY (`user_id`) REFERENCES `users`(`id`) ON DELETE CASCADE
);

-- Create free_trial_tracking table if not exists
CREATE TABLE IF NOT EXISTS `free_trial_tracking` (
  `id` int(11) NOT NULL AUTO_INCREMENT PRIMARY KEY,
  `user_id` int(11) NOT NULL UNIQUE,
  `trial_searches_limit` int(11) DEFAULT 10,
  `trial_searches_used` int(11) DEFAULT 0,
  `is_trial_active` tinyint(1) DEFAULT 1,
  `trial_started_at` datetime NOT NULL,
  `trial_ended_at` datetime,
  `created_at` timestamp DEFAULT CURRENT_TIMESTAMP,
  `updated_at` timestamp DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  FOREIGN KEY (`user_id`) REFERENCES `users`(`id`) ON DELETE CASCADE
);

-- Insert sample plans if table is empty
INSERT INTO `subscription_plans` (`plan_name`, `duration_days`, `search_limit`, `price`, `description`, `is_active`)
SELECT '7 Days Trial', 7, 20, 49.99, '7 days access with 20 searches', 1
FROM dual WHERE NOT EXISTS (SELECT * FROM subscription_plans);

INSERT INTO `subscription_plans` (`plan_name`, `duration_days`, `search_limit`, `price`, `description`, `is_active`)
SELECT '30 Days Basic', 30, 100, 199.99, '30 days access with 100 searches', 1
FROM dual WHERE NOT EXISTS (SELECT * FROM subscription_plans WHERE plan_name = '30 Days Basic');

INSERT INTO `subscription_plans` (`plan_name`, `duration_days`, `search_limit`, `price`, `description`, `is_active`)
SELECT '90 Days Premium', 90, 500, 499.99, '90 days access with 500 searches', 1
FROM dual WHERE NOT EXISTS (SELECT * FROM subscription_plans WHERE plan_name = '90 Days Premium');

INSERT INTO `subscription_plans` (`plan_name`, `duration_days`, `search_limit`, `price`, `description`, `is_active`)
SELECT '365 Days Plus', 365, 2000, 999.99, '1 year access with 2000 searches', 1
FROM dual WHERE NOT EXISTS (SELECT * FROM subscription_plans WHERE plan_name = '365 Days Plus');
