<?php
/**
 * Admin Email Settings - Clean Version
 */

// Get database instance if not already set
if (!isset($db)) {
    require_once __DIR__ . '/../../classes/Database.php';
    $db = Database::getInstance();
}

// Handle form submission
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['save_email_settings'])) {
    $mail_username = trim($_POST['mail_username'] ?? '');
    $mail_from_email = trim($_POST['mail_from_email'] ?? '');
    $mail_from_name = trim($_POST['mail_from_name'] ?? '');
    $test_email = trim($_POST['test_email'] ?? '');
    
    $settingKeys = [
        'mail_username' => $mail_username,
        'mail_from_email' => $mail_from_email,
        'mail_from_name' => $mail_from_name,
        'test_email' => $test_email
    ];
    
    foreach ($settingKeys as $key => $value) {
        if (empty($value)) continue;
        
        $exists = $db->fetch(
            'SELECT id FROM admin_settings WHERE setting_key = ?',
            [$key]
        );
        
        if ($exists) {
            $db->update(
                'admin_settings',
                ['setting_value' => $value],
                'setting_key = ?',
                [$key]
            );
        } else {
            $db->insert(
                'admin_settings',
                ['setting_key' => $key, 'setting_value' => $value]
            );
        }
    }
    
    echo '<div class="alert alert-success alert-dismissible fade show" role="alert">
            ✓ Settings updated successfully!
            <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
          </div>';
}

// Fetch current settings
$settings = [];
$settingsList = ['mail_username', 'mail_from_email', 'mail_from_name', 'test_email'];

foreach ($settingsList as $key) {
    $setting = $db->fetch(
        'SELECT setting_value FROM admin_settings WHERE setting_key = ?',
        [$key]
    );
    $settings[$key] = $setting['setting_value'] ?? '';
}

?>

<div class="card shadow-sm border-0 mb-4">
    <div class="card-header" style="background: linear-gradient(135deg, #667eea 0%, #764ba2 100%); color: white; border: none;">
        <h5 class="mb-0">Email Configuration</h5>
    </div>
    
    <div class="card-body">
        <form method="POST">
            <input type="hidden" name="save_email_settings" value="1">
            
            <div class="mb-3">
                <label class="form-label fw-bold">Admin Email (Username)</label>
                <input type="email" name="mail_username" class="form-control" 
                       value="<?= htmlspecialchars($settings['mail_username']) ?>" 
                       placeholder="admin@example.com" required>
                <small class="text-muted d-block mt-1">Email used to send OTPs</small>
            </div>
            
            <div class="mb-3">
                <label class="form-label fw-bold">From Email Address</label>
                <input type="email" name="mail_from_email" class="form-control" 
                       value="<?= htmlspecialchars($settings['mail_from_email']) ?>" 
                       placeholder="noreply@example.com" required>
                <small class="text-muted d-block mt-1">Sender email in OTP emails</small>
            </div>
            
            <div class="mb-3">
                <label class="form-label fw-bold">From Name</label>
                <input type="text" name="mail_from_name" class="form-control" 
                       value="<?= htmlspecialchars($settings['mail_from_name']) ?>" 
                       placeholder="Advanced Mobile Info" required>
                <small class="text-muted d-block mt-1">Company/app name in emails</small>
            </div>
            
            <div class="mb-3">
                <label class="form-label fw-bold">Test Email Address</label>
                <input type="email" name="test_email" class="form-control" 
                       value="<?= htmlspecialchars($settings['test_email']) ?>" 
                       placeholder="test@example.com">
                <small class="text-muted d-block mt-1">Where to send test emails</small>
            </div>
            
            <button type="submit" class="btn btn-primary btn-lg">Save Settings</button>
        </form>
    </div>
</div>

<div class="card shadow-sm border-0">
    <div class="card-header" style="background: linear-gradient(135deg, #667eea 0%, #764ba2 100%); color: white; border: none;">
        <h5 class="mb-0">User Email Verification Status</h5>
    </div>
    
    <div class="card-body">
        <div class="table-responsive">
            <table class="table table-hover">
                <thead class="table-light">
                    <tr>
                        <th>User</th>
                        <th>Email</th>
                        <th>Status</th>
                        <th>Verified On</th>
                    </tr>
                </thead>
                <tbody>
                    <?php
                    $users = $db->query('SELECT id, name, email, email_verified, email_verified_at FROM users ORDER BY created_at DESC LIMIT 50')->fetchAll(PDO::FETCH_ASSOC);
                    
                    if (!empty($users)) {
                        foreach ($users as $user) {
                            if ($user['email_verified']) {
                                $status = '<span class="badge bg-success">✓ Verified</span>';
                                $date = date('M d, Y', strtotime($user['email_verified_at']));
                            } else {
                                $status = '<span class="badge bg-secondary">Pending</span>';
                                $date = '-';
                            }
                    ?>
                    <tr>
                        <td><strong><?= htmlspecialchars($user['name']) ?></strong></td>
                        <td><?= htmlspecialchars($user['email']) ?></td>
                        <td><?= $status ?></td>
                        <td><?= $date ?></td>
                    </tr>
                    <?php
                        }
                    } else {
                        echo '<tr><td colspan="4" class="text-center text-muted py-3">No users found</td></tr>';
                    }
                    ?>
                </tbody>
            </table>
        </div>
    </div>
</div>

