<?php
// ========== DASHBOARD COUNTS ==========
$totalUsers = $db->fetch('SELECT COUNT(*) AS total FROM users WHERE role="user"')['total'] ?? 0;
$totalSearches = $db->fetch('SELECT COUNT(*) AS total FROM search_logs')['total'] ?? 0;
$totalRevenue = $db->fetch('SELECT SUM(cost) AS total FROM search_logs WHERE status="success"')['total'] ?? 0;
$recentUsers = $db->fetchAll('SELECT name, email, role, is_active FROM users ORDER BY id DESC LIMIT 5');

// ========== LOAD API URLs & TEST CONNECTIVITY ==========
$mobileURL  = $db->fetch("SELECT setting_value FROM admin_settings WHERE setting_key='mobile_api_url'")['setting_value'] ?? '';
$aadhaarURL = $db->fetch("SELECT setting_value FROM admin_settings WHERE setting_key='aadhaar_api_url'")['setting_value'] ?? '';

// Simple check: if URL exists and not default = Online, else Offline
$mobileStatus = (!empty($mobileURL) && strpos($mobileURL, 'example.com') === false) ? "online" : "offline";
$aadhaarStatus = (!empty($aadhaarURL) && strpos($aadhaarURL, 'example.com') === false) ? "online" : "offline";

$mobileApi = [
    "status" => $mobileStatus,
    "display" => ($mobileStatus === "online") ? "Online" : "Offline"
];

$aadhaarApi = [
    "status" => $aadhaarStatus,
    "display" => ($aadhaarStatus === "online") ? "Online" : "Offline"
];



// ========== SERVER INFO ==========
$memoryUsage = round(memory_get_usage(true) / 1024 / 1024, 2);
$loadAvg = function_exists('sys_getloadavg') ? sys_getloadavg()[0] : "N/A";
?>

<style>
/* RESPONSIVE CARD STYLE */
.stats-card {
    background: white;
    padding: 18px;
    border-radius: 16px;
    box-shadow: 0 4px 18px rgba(0,0,0,0.06);
    text-align: center;
    margin-bottom: 1rem;
}
.stats-card h6 {
    font-size: 14px;
    color: #444;
}
.stats-card h3 {
    font-size: 26px;
    font-weight: 700;
}

/* TABLE RESPONSIVE WRAPPER */
.table-responsive {
    overflow-x: auto;
    -webkit-overflow-scrolling: touch;
}

/* SYSTEM HEALTH BOX MOBILE FIX */
@media (max-width: 768px) {
    .system-box {
        max-width: 100% !important;
        width: 100% !important;
    }
}
</style>

<h3>Welcome, <?= htmlspecialchars($currentUser['name']); ?> 👋</h3>
<p class="text-muted">System Overview</p>

<!-- SUMMARY CARDS -->
<div class="row mb-4">
    <div class="col-12 col-sm-6 col-md-4"><div class="stats-card"><h6>Total Users</h6><h3><?= $totalUsers ?></h3></div></div>
    <div class="col-12 col-sm-6 col-md-4"><div class="stats-card"><h6>Total Searches</h6><h3><?= $totalSearches ?></h3></div></div>
    <div class="col-12 col-sm-6 col-md-4"><div class="stats-card"><h6>Total Revenue</h6><h3>₹<?= number_format($totalRevenue,2) ?></h3></div></div>
</div>

<!-- RECENT USERS -->
<div class="card p-4 mb-4">
    <h5>Recent Users</h5>

    <div class="table-responsive mt-3">
        <table class="table table-striped">
            <thead><tr><th>Name</th><th>Email</th><th>Role</th><th>Status</th></tr></thead>
            <tbody>
            <?php foreach ($recentUsers as $user): ?>
                <tr>
                    <td><?= htmlspecialchars($user['name']) ?></td>
                    <td><?= htmlspecialchars($user['email']) ?></td>
                    <td><?= ucfirst($user['role']) ?></td>
                    <td><span class="badge bg-<?= $user['is_active']?'success':'danger' ?>"><?= $user['is_active']?'Active':'Inactive' ?></span></td>
                </tr>
            <?php endforeach; ?>
            </tbody>
        </table>
    </div>
</div>

<!-- SYSTEM HEALTH -->
<div class="card p-3 mb-4 system-box" style="border-radius:14px; max-width:460px;">
    <h5 class="mb-3">⚡ System Health</h5>

    <style>
        .badge-gold { background:#10b981 !important; color:#fff; font-weight:600; }
        .badge-danger { background:#dc3545 !important; color:#fff; font-weight:600; }
        .icon-glow { filter: drop-shadow(0 0 6px #10b981); color:#10b981 !important; }
    </style>

    <div class="small text-muted mb-2">API Status</div>

    <div class="d-flex justify-content-between mb-2">
        <span><i class="icon-glow" data-feather="smartphone" style="width:16px;height:16px;"></i> Mobile API</span>
        <span><span class="badge badge-<?= ($mobileApi['status'] === "online") ? 'gold' : 'danger' ?>"><?= $mobileApi['display'] ?></span></span>
    </div>

    <div class="d-flex justify-content-between mb-3">
        <span><i class="icon-glow" data-feather="credit-card" style="width:16px;height:16px;"></i> Aadhaar API</span>
        <span><span class="badge badge-<?= ($aadhaarApi['status'] === "online") ? 'gold' : 'danger' ?>"><?= $aadhaarApi['display'] ?></span></span>
    </div>

    <div class="small text-muted mb-2">Server</div>

    <div class="d-flex justify-content-between mb-1">
        <span><i class="icon-glow" data-feather="database" style="width:16px;height:16px;"></i> Database</span>
        <span class="badge badge-gold">Connected</span>
    </div>

    <div class="d-flex justify-content-between mb-1">
        <span><i class="icon-glow" data-feather="cpu" style="width:16px;height:16px;"></i> Server Load</span>
        <span class="fw-bold"><?= $loadAvg ?></span>
    </div>

    <div class="d-flex justify-content-between mb-1">
        <span><i class="icon-glow" data-feather="activity" style="width:16px;height:16px;"></i> Memory</span>
        <span class="fw-bold"><?= $memoryUsage ?> MB</span>
    </div>

    <div class="d-flex justify-content-between">
        <span><i class="icon-glow" data-feather="code" style="width:16px;height:16px;"></i> PHP Version</span>
        <span class="fw-bold"><?= phpversion(); ?></span>
    </div>
</div>

<script>feather.replace()</script>
