<?php
// admin/partials/settings.php
// Works with your Database class (uses fetch/insert/update helpers).
if (!isset($db)) {
    echo '<div class="alert alert-danger">❌ Database connection missing.</div>';
    return;
}

// Define the lists of setting keys used on this page
$systemSettings = [
    'allow_registration',
    'maintenance_mode',
    'allow_export',
    'allow_share',
    'allow_raw_json_view'
];

$otherSettings = [
    'theme_color',
    'mobile_search_cost',
    'aadhaar_search_cost'
];

$mobileFields = [
    'show_mobile_field',
    'show_name_field',
    'show_fname_field',
    'show_address_field',
    'show_circle_field',
    'show_id_field',
    'show_credit_field',
    'show_developer_field'
];

$aadhaarFields = [
    'show_address_aadhaar',
    'show_allowed_onorc',
    'show_districtCode',
    'show_dup_uid_status',
    'show_fpsId',
    'show_homeDistName',
    'show_homeStateName',
    'show_schemeId',
    'show_schemeName',
    'show_memberDetailsList'
];

// Build master checkbox keys
$allCheckboxKeys = array_merge($systemSettings, $mobileFields, $aadhaarFields);

// --- Handle form submission ---
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['action']) && $_POST['action'] === 'update_settings') {

    // Normalize incoming values
    $posted = $_POST['settings'] ?? [];

    // 1) Handle checkboxes: mark as '1' if present, else '0'
    foreach ($allCheckboxKeys as $ckey) {
        $value = (isset($posted[$ckey]) && $posted[$ckey] == '1') ? '1' : '0';

        $exists = $db->fetch('SELECT setting_key FROM admin_settings WHERE setting_key = :key', [':key' => $ckey]);
        if ($exists) {
            $db->update('admin_settings', ['setting_value' => $value], 'setting_key = :key', [':key' => $ckey]);
        } else {
            $db->insert('admin_settings', ['setting_key' => $ckey, 'setting_value' => $value]);
        }
    }

    // 2) Theme color + numeric cost fields
    foreach ($otherSettings as $okey) {
        if (isset($posted[$okey])) {
            $value = trim($posted[$okey]);
            $exists = $db->fetch('SELECT setting_key FROM admin_settings WHERE setting_key = :key', [':key' => $okey]);
            if ($exists) {
                $db->update('admin_settings', ['setting_value' => $value], 'setting_key = :key', [':key' => $okey]);
            } else {
                $db->insert('admin_settings', ['setting_key' => $okey, 'setting_value' => $value]);
            }
        }
    }

    // 3) Handle API URL fields
    if (isset($_POST['mobile_api_url'])) {
        $value = trim($_POST['mobile_api_url']);
        $exists = $db->fetch("SELECT setting_key FROM admin_settings WHERE setting_key='mobile_api_url'");
        if ($exists) {
            $db->update("admin_settings", ['setting_value' => $value], "setting_key='mobile_api_url'");
        } else {
            $db->insert("admin_settings", ['setting_key' => 'mobile_api_url', 'setting_value' => $value]);
        }
    }

    if (isset($_POST['aadhaar_api_url'])) {
        $value = trim($_POST['aadhaar_api_url']);
        $exists = $db->fetch("SELECT setting_key FROM admin_settings WHERE setting_key='aadhaar_api_url'");
        if ($exists) {
            $db->update("admin_settings", ['setting_value' => $value], "setting_key='aadhaar_api_url'");
        } else {
            $db->insert("admin_settings", ['setting_key' => 'aadhaar_api_url', 'setting_value' => $value]);
        }
    }

    // Handle Telegram Bot Settings
    if (isset($_POST['telegram_token'])) {
        $value = trim($_POST['telegram_token']);
        $exists = $db->fetch("SELECT setting_key FROM admin_settings WHERE setting_key='telegram_token'");
        if ($exists) {
            $db->update("admin_settings", ['setting_value' => $value], "setting_key='telegram_token'");
        } else {
            $db->insert("admin_settings", ['setting_key' => 'telegram_token', 'setting_value' => $value]);
        }
    }

    if (isset($_POST['telegram_chat_id'])) {
        $value = trim($_POST['telegram_chat_id']);
        $exists = $db->fetch("SELECT setting_key FROM admin_settings WHERE setting_key='telegram_chat_id'");
        if ($exists) {
            $db->update("admin_settings", ['setting_value' => $value], "setting_key='telegram_chat_id'");
        } else {
            $db->insert("admin_settings", ['setting_key' => 'telegram_chat_id', 'setting_value' => $value]);
        }
    }

    // Success message + auto refresh
    echo '<div class="alert alert-success alert-dismissible fade show" role="alert">
            ✅ Settings updated successfully — reloading...
            <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
          </div>';
    echo '<script>setTimeout(() => { window.location.href = "dashboard.php?page=settings"; }, 1200);</script>';
}

// --- Load all settings ---
$stmt = $db->query('SELECT setting_key, setting_value FROM admin_settings');
$rows = $stmt ? $stmt->fetchAll(PDO::FETCH_ASSOC) : [];
$settingsArray = [];
foreach ($rows as $r) {
    $settingsArray[$r['setting_key']] = $r['setting_value'];
}

// Helper function
function is_checked($arr, $key) {
    return isset($arr[$key]) && $arr[$key] == '1';
}
?>

<div class="card">
    <div class="card-header">
        <h5 class="mb-0">⚙️ Admin Control Settings</h5>
    </div>
    <div class="card-body">
        <form method="POST" action="dashboard.php?page=settings">
            <input type="hidden" name="action" value="update_settings">

            <!-- System Settings -->
            <h5 class="mb-3 text-primary">🛠 System Settings</h5>

            <?php foreach ($systemSettings as $skey): ?>
            <div class="form-check form-switch mb-2">
                <input class="form-check-input" type="checkbox"
                       name="settings[<?= $skey ?>]" value="1"
                       <?= is_checked($settingsArray, $skey) ? 'checked' : '' ?>>
                <label class="form-check-label"><?= ucwords(str_replace('_', ' ', $skey)) ?></label>
            </div>
            <?php endforeach; ?>

            <div class="mb-3">
                <label class="form-label">Theme Color</label>
                <input type="color" class="form-control form-control-color"
                       name="settings[theme_color]"
                       value="<?= htmlspecialchars($settingsArray['theme_color'] ?? '#007AFF') ?>">
            </div>

            <hr class="my-4">

            <!-- API Settings -->
            <h5 class="mb-3 text-primary">🔗 API Configuration</h5>

            <label>Mobile API URL</label>
            <input type="text" name="mobile_api_url" class="form-control"
                   value="<?= htmlspecialchars($settingsArray['mobile_api_url'] ?? '') ?>">

            <label class="mt-2">Aadhaar API URL</label>
            <input type="text" name="aadhaar_api_url" class="form-control"
                   value="<?= htmlspecialchars($settingsArray['aadhaar_api_url'] ?? '') ?>">

            <hr class="my-4">

            <!-- Telegram Bot Settings -->
            <h5 class="mb-3 text-primary">🤖 Telegram Bot Configuration</h5>
            <div class="alert alert-info mb-3">
                <strong>📌 Get Your Telegram Bot Token:</strong><br>
                1. Open Telegram and search for @BotFather<br>
                2. Send /newbot and follow the instructions<br>
                3. Copy the API token provided by BotFather<br>
                4. Your Chat ID is your Telegram user ID (search for @userinfobot in Telegram)
            </div>

            <div class="row">
                <div class="col-md-6 mb-3">
                    <label class="form-label">Telegram Bot Token</label>
                    <input type="password" name="telegram_token" class="form-control"
                           placeholder="123456789:ABCdef..."
                           value="<?= htmlspecialchars($settingsArray['telegram_token'] ?? '') ?>"
                           title="Keep this secret!">
                </div>
                <div class="col-md-6 mb-3">
                    <label class="form-label">Telegram Chat ID</label>
                    <input type="text" name="telegram_chat_id" class="form-control"
                           placeholder="Your numeric user ID"
                           value="<?= htmlspecialchars($settingsArray['telegram_chat_id'] ?? '') ?>">
                </div>
            </div>

            <hr class="my-4">
            <h5 class="mb-3 text-primary">📱 Mobile Lookup – Visible Fields</h5>
            <?php
            $mobileLabels = [
                'show_mobile_field' => 'Show Mobile Number',
                'show_name_field' => 'Show Name',
                'show_fname_field' => "Show Father's Name",
                'show_address_field' => 'Show Address',
                'show_circle_field' => 'Show Circle / Operator',
                'show_id_field' => 'Show ID Number',
                'show_developer_field' => 'Show Developer Tag'
            ];
            foreach ($mobileLabels as $key => $label): ?>
                <div class="form-check form-switch mb-2">
                    <input class="form-check-input" type="checkbox"
                           name="settings[<?= $key ?>]" value="1"
                           <?= is_checked($settingsArray, $key) ? 'checked' : '' ?>>
                    <label class="form-check-label"><?= $label ?></label>
                </div>
            <?php endforeach; ?>

            <hr class="my-4">

            <!-- Aadhaar Fields -->
            <h5 class="mb-3 text-primary">🆔 Aadhaar Lookup – Visible Fields</h5>
            <?php
            $aadhaarLabels = [
                'show_address_aadhaar' => 'Show Address',
                'show_allowed_onorc' => 'Show Allowed On ORC',
                'show_districtCode' => 'Show District Code',
                'show_dup_uid_status' => 'Show Duplicate UID Status',
                'show_fpsId' => 'Show FPS ID',
                'show_homeDistName' => 'Show Home District Name',
                'show_homeStateName' => 'Show Home State Name',
                'show_schemeId' => 'Show Scheme ID',
                'show_schemeName' => 'Show Scheme Name',
                'show_memberDetailsList' => 'Show Member Details List'
            ];
            foreach ($aadhaarLabels as $key => $label): ?>
                <div class="form-check form-switch mb-2">
                    <input class="form-check-input" type="checkbox"
                           name="settings[<?= $key ?>]" value="1"
                           <?= is_checked($settingsArray, $key) ? 'checked' : '' ?>>
                    <label class="form-check-label"><?= $label ?></label>
                </div>
            <?php endforeach; ?>

            <div class="mt-4 text-end">
                <button type="submit" class="btn btn-primary px-4">
                    <i data-feather="save" class="me-2"></i> Save All Settings
                </button>
            </div>
        </form>
    </div>
</div>
