<?php
require_once __DIR__ . '/../../classes/Database.php';
require_once __DIR__ . '/../../classes/SubscriptionManager.php';
$db = Database::getInstance();
$subscriptionMgr = new SubscriptionManager();

/* ============================================================
   FETCH ALL USERS WITH SUBSCRIPTION INFO
   ============================================================ */
$users = $db->fetchAll("SELECT * FROM users ORDER BY id DESC");
?>

<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>

<style>

/* Data Source Indicator */
.data-source-indicator {
    display: inline-block;
    width: 12px;
    height: 12px;
    border-radius: 50%;
    margin-right: 8px;
    vertical-align: middle;
    animation: pulse 2s infinite;
}

.data-source-indicator.live {
    background: #10b981;
    box-shadow: 0 0 8px rgba(16, 185, 129, 0.5);
}

.data-source-indicator.cached {
    background: #f59e0b;
    box-shadow: 0 0 8px rgba(245, 158, 11, 0.5);
}

@keyframes pulse {
    0%, 100% { opacity: 1; }
    50% { opacity: 0.6; }
}

.data-source-label {
    font-size: 12px;
    font-weight: 600;
    color: #666;
}

/* Simple Toggle */
.simple-toggle {
    width: 36px; height: 18px; appearance:none;
    background:#c4c4c4; border-radius:20px;
    position:relative; cursor:pointer; transition:0.2s;
}
.simple-toggle:checked { background:#28a745; }
.simple-toggle::before {
    content:""; width:14px; height:14px; background:white;
    position:absolute; top:2px; left:2px; border-radius:50%; transition:0.2s;
}
.simple-toggle:checked::before { transform:translateX(18px); }

/* RESPONSIVE TABLE FIX */
.table-responsive {
    overflow-x: auto;
    -webkit-overflow-scrolling: touch;
}

/* TABLE STYLING */
.table {
    margin: 0;
    border-collapse: collapse;
    background: white;
}

.table thead {
    background: linear-gradient(135deg, #007bff 0%, #0056b3 100%);
    color: white;
    font-weight: 700;
    letter-spacing: 0.5px;
}

.table thead th {
    padding: 18px 12px;
    border: none;
    color: white !important;
    font-size: 13px;
    text-transform: uppercase;
    letter-spacing: 0.5px;
    background: linear-gradient(135deg, #007bff 0%, #0056b3 100%);
}

.table tbody tr {
    border-bottom: 2px solid #f0f0f0;
    transition: all 0.2s ease;
    background: #ffffff;
}

.table tbody tr:hover {
    background-color: #f5f8ff;
    box-shadow: inset 0 2px 8px rgba(0, 123, 255, 0.1);
}

.table tbody tr:nth-child(odd) {
    background: #ffffff;
}

.table tbody td {
    padding: 14px 12px;
    vertical-align: middle;
    font-size: 13px;
    color: #333;
    font-weight: 500;
}

.table code {
    background: #ffe6e6;
    padding: 5px 10px;
    border-radius: 4px;
    font-family: 'Monaco', 'Courier New', monospace;
    font-size: 11px;
    color: #c41e3a;
    font-weight: 600;
}

/* BADGE STYLES */
.badge {
    padding: 7px 12px;
    font-size: 11px;
    font-weight: 700;
    border-radius: 6px;
    display: inline-block;
    text-transform: uppercase;
    letter-spacing: 0.3px;
}

.badge.bg-info {
    background: #0dcaf0 !important;
    color: white;
}

.badge.bg-secondary {
    background: #6c757d !important;
    color: white;
}

.badge.bg-success {
    background: #198754 !important;
    color: white;
}

.badge.bg-warning {
    background: #ffc107 !important;
    color: #000;
}

/* ACTION BUTTONS STYLING */
.action-btns {
    display: flex;
    gap: 5px;
    justify-content: center;
    flex-wrap: wrap;
}

.btn-sm {
    padding: 5px 10px;
    font-size: 11px;
    font-weight: 600;
    border-radius: 5px;
    border: none;
    transition: all 0.2s ease;
    box-shadow: 0 2px 6px rgba(0,0,0,0.1);
    cursor: pointer;
    text-transform: uppercase;
    letter-spacing: 0.3px;
}

.btn-sm:hover {
    transform: translateY(-1px);
    box-shadow: 0 3px 10px rgba(0,0,0,0.15);
}

.btn-warning {
    background: #ffc107 !important;
    color: #000 !important;
}

.btn-info {
    background: #0dcaf0 !important;
    color: white !important;
}

.btn-danger {
    background: #dc3545 !important;
    color: white !important;
}

.btn-warning:hover {
    background: #e0a800 !important;
}

.btn-info:hover {
    background: #0aa2c0 !important;
}

.btn-danger:hover {
    background: #bb2d3b !important;
}

/* RESPONSIVE ACTION BUTTON STACK */
@media (max-width: 768px) {
    .action-btns {
        display: flex;
        flex-direction: column;
        gap: 4px;
    }
    
    .table thead th {
        padding: 12px 8px;
        font-size: 11px;
    }
    
    .table tbody td {
        padding: 10px 8px;
        font-size: 12px;
    }
    
    .btn-sm {
        padding: 4px 8px;
        font-size: 10px;
    }
}

/* MODAL */
#coinsModal {
    display:none; position:fixed; inset:0;
    background:rgba(0,0,0,0.6);
    justify-content:center; align-items:center;
    z-index:9999;
}

#coinsModal .modal-box {
    background:#fff; 
    padding:20px; 
    width:90%; 
    max-width:350px; 
    border-radius:8px;
}

#passwordModal {
    display:none; position:fixed; inset:0;
    background:rgba(0,0,0,0.6);
    justify-content:center; align-items:center;
    z-index:9999;
}

#passwordModal .modal-box {
    background:#fff; 
    padding:20px; 
    width:90%; 
    max-width:350px; 
    border-radius:8px;
}

/* TEXT ALIGNMENT */
.text-muted {
    color: #999 !important;
    font-style: italic;
}

/* CARD STYLING */
.card {
    border: none;
    border-radius: 12px;
    box-shadow: 0 4px 20px rgba(0,0,0,0.08);
    overflow: hidden;
}

.card-body {
    padding: 0;
}

</style>


<div class="container-fluid">

    <div style="display: flex; justify-content: space-between; align-items: center; margin-bottom: 20px;">
        <h4 class="mb-0">👤 User Management</h4>
    </div>

    <div class="card shadow-sm">
        <div class="card-body table-responsive">

            <table class="table table-bordered align-middle">
                <thead class="table-light text-center">
                    <tr>
                        <th>ID</th>
                        <th>User</th>
                        <th>Email</th>
                        <th>Device</th>
                        <th>IP Address</th>
                        <th>Last Login</th>
                        <th>Subscription Status</th>
                        <th>Active</th>
                        <th>Action</th>
                    </tr>
                </thead>

                <tbody>

                <?php foreach ($users as $u): ?>

                    <tr class="text-center">

                        <td><?= $u['id'] ?></td>

                        <td>
                            <?= htmlspecialchars($u['name']) ?><br>
                            
                            <?php if ($u['role'] === 'admin'): ?>
                                <span class="badge bg-warning text-dark mt-1">Admin</span>
                            <?php else: ?>
                                <span class="badge bg-success mt-1">User</span>
                            <?php endif; ?>
                        </td>

                        <td><?= htmlspecialchars($u['email']) ?></td>

                        <td>
                            <?php if (!empty($u['login_device'])): ?>
                                <?php 
                                    $device = strtolower($u['login_device']);
                                    if (strpos($device, 'mobile') !== false || strpos($device, 'android') !== false || strpos($device, 'iphone') !== false):
                                ?>
                                    <span class="badge bg-info"><i class="bi bi-phone"></i> Mobile</span>
                                <?php else: ?>
                                    <span class="badge bg-secondary"><i class="bi bi-laptop"></i> Desktop</span>
                                <?php endif; ?>
                            <?php else: ?>
                                <span class="text-muted">-</span>
                            <?php endif; ?>
                        </td>

                        <td>
                            <?php if (!empty($u['login_ip'])): ?>
                                <code><?= htmlspecialchars($u['login_ip']) ?></code>
                            <?php else: ?>
                                <span class="text-muted">-</span>
                            <?php endif; ?>
                        </td>

                        <td>
                            <?php if (!empty($u['last_login_at'])): ?>
                                <small><?= date('M d, Y H:i', strtotime($u['last_login_at'])) ?></small>
                            <?php else: ?>
                                <span class="text-muted">Never</span>
                            <?php endif; ?>
                        </td>

                        <td>
                            <?php 
                                $userSub = $db->fetch("SELECT * FROM user_subscriptions WHERE user_id = ? AND status = 'active' ORDER BY end_date DESC LIMIT 1", [$u['id']]);
                                if ($userSub):
                                    $plan = $db->fetch("SELECT plan_name FROM subscription_plans WHERE id = ?", [$userSub['plan_id']]);
                            ?>
                                <span class="badge bg-success"><?php echo htmlspecialchars($plan['plan_name'] ?? 'Plan'); ?></span><br>
                                <small class="text-muted"><?php echo date('M d', strtotime($userSub['end_date'])); ?></small>
                            <?php else: ?>
                                <span class="badge bg-secondary">No Subscription</span>
                            <?php endif; ?>
                        </td>

                        <td>
                            <input type="checkbox"
                                   class="simple-toggle toggle-control"
                                   data-id="<?= $u['id'] ?>"
                                   data-field="is_active"
                                   <?= $u['is_active'] ? "checked" : "" ?>>
                        </td>

                        <td>

                            <div class="action-btns">

                                <button class="btn btn-info btn-sm"
                                    onclick="openPasswordModal(<?= $u['id'] ?>, '<?= htmlspecialchars($u['name']) ?>')">
                                    Reset Password
                                </button>

                                <a href="dashboard.php?page=users&delete_user=<?= $u['id'] ?>"
                                   onclick="return confirm('Delete this user?')"
                                   class="btn btn-danger btn-sm">
                                   Delete
                                </a>

                            </div>

                        </td>

                    </tr>

                <?php endforeach; ?>

                </tbody>

            </table>

        </div>
    </div>
</div>


<!-- PASSWORD MODAL -->
<div id="passwordModal">
    <div class="modal-box">
        <h5 id="passwordModalTitle" class="text-center mb-3">Reset Password</h5>

        <form id="passwordForm">

            <input type="hidden" name="user_id" id="passwordUserId">

            <label>New Password:</label>
            <input type="password" name="new_password" id="newPasswordInput" class="form-control" required min="6" placeholder="Min 6 characters">

            <label class="mt-2">Confirm Password:</label>
            <input type="password" name="confirm_password" id="confirmPasswordInput" class="form-control" required placeholder="Confirm password">

            <button class="btn btn-primary w-100 mt-3">Update Password</button>

            <button type="button" class="btn btn-secondary w-100 mt-2"
                    onclick="closePasswordModal()">Cancel</button>
        </form>
    </div>
</div>


<script>
// MODAL CONTROLS
function openPasswordModal(id, name) {
    document.getElementById("passwordUserId").value = id;
    document.getElementById("passwordModalTitle").innerText = "Reset Password: " + name;
    document.getElementById("passwordModal").style.display = "flex";
}

function closePasswordModal() {
    document.getElementById("passwordModal").style.display = "none";
}
</script>


<!-- AJAX PASSWORD UPDATE -->
<script>
if (document.getElementById("passwordForm")) {
    document.getElementById("passwordForm").addEventListener("submit", function(e) {
        e.preventDefault();

        let newPass = document.getElementById("newPasswordInput").value.trim();
        let confirmPass = document.getElementById("confirmPasswordInput").value.trim();
        let userId = document.getElementById("passwordUserId").value;

        if (!newPass || !confirmPass) {
            Swal.fire({ icon:"warning", title:"All fields required", timer:1400, showConfirmButton:false });
            return;
        }

        if (newPass !== confirmPass) {
            Swal.fire({ icon:"warning", title:"Passwords do not match", timer:1400, showConfirmButton:false });
            return;
        }

        if (newPass.length < 6) {
            Swal.fire({ icon:"warning", title:"Password must be at least 6 characters", timer:1400, showConfirmButton:false });
            return;
        }

        let formData = new FormData();
        formData.append("ajax_password", "1");
        formData.append("user_id", userId);
        formData.append("new_password", newPass);

        fetch("/extract/admin/reset_password.php", {
            method: "POST",
            body: formData
        })
        .then(res => {
            if (!res.ok) throw new Error('HTTP ' + res.status);
            return res.text();
        })
        .then(msg => {
            console.log("Server response:", msg.trim());
            closePasswordModal();

            if (msg.trim() === "OK") {
                Swal.fire({ 
                    icon:"success", 
                    title:"✅ Password Updated!", 
                    text:"User password has been changed successfully",
                    timer:2000, 
                    showConfirmButton:false 
                });
                setTimeout(() => location.reload(), 2100);
            } else if (msg.includes("INVALID")) {
                Swal.fire({ icon:"error", title:"❌ Invalid Password", text:"Password must be at least 6 characters" });
            } else if (msg.includes("USER_NOT_FOUND")) {
                Swal.fire({ icon:"error", title:"❌ User Not Found", text:"This user does not exist" });
            } else if (msg.includes("ERROR")) {
                Swal.fire({ icon:"error", title:"❌ Error", text:msg });
            } else {
                Swal.fire({ icon:"error", title:"❌ Failed", text:"Failed to update password: " + msg });
            }
        })
        .catch(err => {
            console.error("Fetch error:", err);
            Swal.fire({ icon:"error", title:"Network Error", text:err.message });
        });
    });
}
</script>


<!-- ACTIVE TOGGLE AJAX -->
<script>
document.querySelectorAll(".toggle-control").forEach(el => {
    el.addEventListener("change", function () {

        fetch("ajax_update_user.php", {
            method: "POST",
            headers: { "Content-Type": "application/x-www-form-urlencoded" },
            body: `id=${this.dataset.id}&field=${this.dataset.field}&value=${this.checked ? 1 : 0}`
        });

    });
});
</script>
