<?php
/**
 * Resend OTP from Modal Popup
 * Used in user profile email verification
 */

header('Content-Type: application/json');

require_once '../config/config.php';
require_once '../classes/Database.php';
require_once '../classes/Auth.php';
require_once '../classes/OTPManager.php';

$db = Database::getInstance();
$auth = new Auth($db);

// Check if user is logged in
if (!$auth->isLoggedIn()) {
    echo json_encode(['success' => false, 'message' => 'Not authenticated']);
    exit();
}

$data = json_decode(file_get_contents('php://input'), true);
$email = trim($data['email'] ?? '');

if (empty($email)) {
    echo json_encode(['success' => false, 'message' => 'Email is required']);
    exit();
}

// Verify email belongs to logged-in user
$user = $db->fetch('SELECT id FROM users WHERE email = ?', [$email]);
if (!$user || $user['id'] != $auth->getCurrentUser()['id']) {
    echo json_encode(['success' => false, 'message' => 'Unauthorized']);
    exit();
}

// Generate and send new OTP
$otp = new OTPManager($db);
$result = $otp->generateAndSendOTP($email);

if ($result) {
    echo json_encode(['success' => true, 'message' => 'New OTP sent to your email']);
} else {
    echo json_encode(['success' => false, 'message' => 'Failed to send OTP. Please try again.']);
}
