<?php
/**
 * Brevo Email Sending Implementation
 * FREE: 300 emails/day
 * Perfect for OTP verification
 */

class BrevoOTPSender {
    private $apiKey;
    private $fromEmail;
    private $fromName;
    
    public function __construct($apiKey, $fromEmail, $fromName = 'Advanced Mobile Info') {
        $this->apiKey = $apiKey;
        $this->fromEmail = $fromEmail;
        $this->fromName = $fromName;
    }
    
    /**
     * Send OTP via Brevo API
     */
    public function sendOTP($toEmail, $otp, $userName = '') {
        $subject = 'Your OTP Verification Code';
        
        $htmlContent = "
            <html>
                <head>
                    <style>
                        body { font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif; background: #f5f5f5; }
                        .container { background: white; max-width: 500px; margin: 30px auto; padding: 40px; border-radius: 10px; box-shadow: 0 4px 6px rgba(0,0,0,0.1); }
                        .header { text-align: center; margin-bottom: 30px; }
                        .logo { font-size: 24px; font-weight: bold; color: #667eea; }
                        .otp-box { background: linear-gradient(135deg, #667eea 0%, #764ba2 100%); color: white; padding: 20px; border-radius: 8px; margin: 20px 0; font-size: 32px; font-weight: bold; letter-spacing: 5px; }
                        .info { color: #666; margin: 15px 0; font-size: 14px; }
                        .warning { background: #fff3cd; color: #856404; padding: 10px; border-radius: 5px; margin: 15px 0; }
                        .footer { text-align: center; color: #999; font-size: 12px; margin-top: 30px; }
                    </style>
                </head>
                <body>
                    <div class='container'>
                        <div class='header'>
                            <div class='logo'>🔐 Advanced Mobile Info</div>
                        </div>
                        
                        <div class='content'>
                            <h2>Email Verification</h2>
                            <p>Hi " . htmlspecialchars($userName) . ",</p>
                            <p>Your OTP verification code is:</p>
                            
                            <div class='otp-box'>" . $otp . "</div>
                            
                            <div class='info'>
                                <p>This code will expire in 5 minutes</p>
                            </div>
                            
                            <div class='warning'>
                                ⚠️ Never share this code with anyone.
                            </div>
                            
                            <p style='color: #666; margin-top: 20px;'>
                                If you didn't request this code, please ignore this email.
                            </p>
                        </div>
                        
                        <div class='footer'>
                            <p>&copy; 2025 Advanced Mobile Info. All rights reserved.</p>
                        </div>
                    </div>
                </body>
            </html>
        ";
        
        // Prepare Brevo API request
        $payload = [
            'sender' => [
                'name' => $this->fromName,
                'email' => $this->fromEmail
            ],
            'to' => [
                [
                    'email' => $toEmail,
                    'name' => $userName
                ]
            ],
            'subject' => $subject,
            'htmlContent' => $htmlContent,
            'textContent' => "Your OTP: $otp. This code expires in 5 minutes."
        ];
        
        // Send via Brevo API
        $curl = curl_init();
        curl_setopt_array($curl, [
            CURLOPT_URL => 'https://api.brevo.com/v3/smtp/email',
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_ENCODING => '',
            CURLOPT_MAXREDIRS => 10,
            CURLOPT_TIMEOUT => 0,
            CURLOPT_FOLLOWLOCATION => true,
            CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
            CURLOPT_CUSTOMREQUEST => 'POST',
            CURLOPT_POSTFIELDS => json_encode($payload),
            CURLOPT_HTTPHEADER => [
                'Accept: application/json',
                'Content-Type: application/json',
                'api-key: ' . $this->apiKey
            ]
        ]);
        
        $response = curl_exec($curl);
        $httpCode = curl_getinfo($curl, CURLINFO_HTTP_CODE);
        curl_close($curl);
        
        if ($httpCode >= 200 && $httpCode < 300) {
            error_log("BREVO OTP: Successfully sent to $toEmail");
            return ['success' => true, 'message' => 'OTP sent successfully'];
        } else {
            error_log("BREVO OTP: Failed to send to $toEmail - HTTP $httpCode - Response: $response");
            return ['success' => false, 'message' => 'Failed to send OTP'];
        }
    }
}

// Usage Example:
/*
$brevo = new BrevoOTPSender(
    'your_brevo_api_key_here',
    'noreply@simplechecks.xyz',
    'Advanced Mobile Info'
);

$result = $brevo->sendOTP('user@example.com', '123456', 'John Doe');
if ($result['success']) {
    echo "OTP sent!";
} else {
    echo "OTP failed!";
}
*/

?>
