<?php
/**
 * Device Restriction Checker
 * Add this to login.php or index.php to check device restrictions
 */

function checkDeviceRestrictions() {
    require_once __DIR__ . '/config/config.php';
    require_once __DIR__ . '/classes/Database.php';
    
    $db = Database::getInstance();
    
    // Get current device
    $ua = $_SERVER['HTTP_USER_AGENT'] ?? '';
    $device = 'Desktop';
    
    if (preg_match('/mobile|android|iphone|windows phone|blackberry|opera mini/i', $ua)) {
        $device = 'Mobile';
    } elseif (preg_match('/tablet|ipad/i', $ua)) {
        $device = 'Tablet';
    }
    
    // Get restrictions
    $block_mobile = $db->fetch('SELECT setting_value FROM admin_settings WHERE setting_key = ?', ['device_block_mobile']);
    $block_tablet = $db->fetch('SELECT setting_value FROM admin_settings WHERE setting_key = ?', ['device_block_tablet']);
    $block_desktop = $db->fetch('SELECT setting_value FROM admin_settings WHERE setting_key = ?', ['device_block_desktop']);
    $message = $db->fetch('SELECT setting_value FROM admin_settings WHERE setting_key = ?', ['device_restriction_message']);
    
    $block_mobile_val = $block_mobile['setting_value'] ?? 0;
    $block_tablet_val = $block_tablet['setting_value'] ?? 0;
    $block_desktop_val = $block_desktop['setting_value'] ?? 0;
    $restriction_message = $message['setting_value'] ?? 'Your device is not allowed to access this application.';
    
    // Check if device is blocked
    $is_blocked = false;
    if ($device === 'Mobile' && $block_mobile_val) {
        $is_blocked = true;
    } elseif ($device === 'Tablet' && $block_tablet_val) {
        $is_blocked = true;
    } elseif ($device === 'Desktop' && $block_desktop_val) {
        $is_blocked = true;
    }
    
    // If blocked, show message
    if ($is_blocked) {
        echo '<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Device Not Allowed</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">
    <style>
        body { background: linear-gradient(135deg, #667eea 0%, #764ba2 100%); min-height: 100vh; display: flex; align-items: center; justify-content: center; }
        .restriction-box { background: white; padding: 40px; border-radius: 12px; box-shadow: 0 10px 40px rgba(0,0,0,0.2); max-width: 500px; text-align: center; }
        .icon { font-size: 80px; margin-bottom: 20px; }
        h2 { color: #333; margin-bottom: 20px; }
        .message { color: #666; font-size: 16px; line-height: 1.6; margin-bottom: 30px; }
        .device-info { background: #f8f9fa; padding: 15px; border-radius: 8px; margin-bottom: 20px; }
        .device-info strong { color: #667eea; }
    </style>
</head>
<body>
    <div class="restriction-box">
        <div class="icon">🚫</div>
        <h2>Access Denied</h2>
        <div class="device-info">
            <strong>Your Device:</strong> ' . $device . '
        </div>
        <p class="message">' . htmlspecialchars($restriction_message) . '</p>
        <small class="text-muted">If you believe this is an error, please contact support.</small>
    </div>
</body>
</html>';
        exit();
    }
}

// Call this function at the top of login.php or user dashboard
// checkDeviceRestrictions();
