<?php
/**
 * OTP Email Sending via FormSubmit (Completely Free, No Setup)
 * 
 * FormSubmit.co sends emails for free without authentication needed
 * No API key required, no signup needed
 * Perfect for Razorhost where mail() doesn't work
 */

class FormSubmitOTPSender {
    private $email_to_send_from = 's26118152@gmail.com';
    private $from_name = 'Advanced Mobile Info';
    
    public function sendOTP($to_email, $otp_code, $user_name = '') {
        try {
            // Use curl to POST to FormSubmit
            $url = 'https://formsubmit.co/' . $this->email_to_send_from;
            
            $subject = '🔐 Your OTP Verification Code';
            $message = "Your OTP: $otp_code\n\nValid for 5 minutes only\n\nDo not share this code with anyone.";
            
            $data = [
                'email' => $to_email,
                'subject' => $subject,
                'message' => $message,
                '_subject' => $subject,
                '_format' => 'json'
            ];
            
            // Perform curl request
            $ch = curl_init();
            curl_setopt($ch, CURLOPT_URL, $url);
            curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
            curl_setopt($ch, CURLOPT_POST, true);
            curl_setopt($ch, CURLOPT_POSTFIELDS, http_build_query($data));
            curl_setopt($ch, CURLOPT_TIMEOUT, 10);
            curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
            
            $response = curl_exec($ch);
            $http_code = curl_getinfo($ch, CURLINFO_HTTP_CODE);
            $curl_error = curl_error($ch);
            curl_close($ch);
            
            if ($curl_error) {
                error_log("FormSubmit cURL Error: $curl_error");
                return false;
            }
            
            error_log("FormSubmit Response: HTTP $http_code");
            
            // FormSubmit returns 200 on success
            return $http_code == 200;
            
        } catch (Exception $e) {
            error_log("FormSubmit Error: " . $e->getMessage());
            return false;
        }
    }
}

?>
