<?php
/**
 * OTP Email Sending via Mailtrap (Free Service)
 * Mailtrap is free and reliable for testing/production
 * 
 * Alternative approach: Use SendGrid or similar service
 */

class MailtrapOTPSender {
    private $api_token = '73bfd050966c8d7c7f984d7002330c80'; // Mailtrap API Token
    private $from_email = 's26118152@gmail.com';
    private $from_name = 'Advanced Mobile Info';
    
    public function sendOTP($to_email, $otp_code, $user_name = '') {
        try {
            $subject = 'Your OTP Verification Code';
            
            // Build HTML email
            $body = $this->buildOTPEmail($otp_code, $user_name);
            
            // Use curl to send via Mailtrap API
            $url = 'https://send.api.mailtrap.io/api/send';
            
            $data = [
                'to' => [
                    ['email' => $to_email, 'name' => $user_name]
                ],
                'from' => [
                    'email' => $this->from_email,
                    'name' => $this->from_name
                ],
                'subject' => $subject,
                'html' => $body,
                'text' => "Your OTP: $otp_code (Valid for 5 minutes)"
            ];
            
            $ch = curl_init();
            curl_setopt($ch, CURLOPT_URL, $url);
            curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
            curl_setopt($ch, CURLOPT_POST, true);
            curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($data));
            curl_setopt($ch, CURLOPT_HTTPHEADER, [
                'Authorization: Bearer ' . $this->api_token,
                'Content-Type: application/json'
            ]);
            
            $response = curl_exec($ch);
            $http_code = curl_getinfo($ch, CURLINFO_HTTP_CODE);
            curl_close($ch);
            
            error_log("Mailtrap response: HTTP $http_code - $response");
            
            return $http_code >= 200 && $http_code < 300;
            
        } catch (Exception $e) {
            error_log("Mailtrap Error: " . $e->getMessage());
            return false;
        }
    }
    
    private function buildOTPEmail($otp, $name) {
        return "
        <div style='font-family: Arial, sans-serif; max-width: 500px; margin: 0 auto;'>
            <h2 style='color: #333;'>🔐 Your OTP Verification Code</h2>
            <p>Hi " . htmlspecialchars($name) . ",</p>
            <p>Your OTP verification code is:</p>
            <div style='background: #f0f0f0; padding: 20px; text-align: center; border-radius: 10px; margin: 20px 0;'>
                <h1 style='color: #007bff; letter-spacing: 10px; margin: 0;'>$otp</h1>
            </div>
            <p><strong>⏱️ Valid for 5 minutes only</strong></p>
            <p style='color: #666; font-size: 12px;'>
                This is an automated message. Please do not reply to this email.
            </p>
        </div>";
    }
}

?>
