-- Create permanent cache table for mobile/aadhaar search results
-- Ye table API data ko permanently store karega

CREATE TABLE IF NOT EXISTS `search_cache` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `type` enum('mobile','aadhaar') NOT NULL,
  `query` varchar(50) NOT NULL,
  `response_json` longtext NOT NULL,
  `data_count` int(11) DEFAULT 1,
  `last_updated` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id`),
  UNIQUE KEY `unique_query` (`type`, `query`),
  INDEX `idx_type` (`type`),
  INDEX `idx_query` (`query`),
  INDEX `idx_last_updated` (`last_updated`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- Agar existing cache table hai toh add index
ALTER TABLE `search_cache` ADD UNIQUE KEY `unique_query` (`type`, `query`) IF NOT EXISTS;
