<?php
/**
 * Face Recognition Setup - Add face_data column to users table
 * This script adds support for Face ID login feature
 */

require_once '../config/config.php';
require_once '../classes/Database.php';

$db = Database::getInstance();

echo "<h2>Face Recognition Setup</h2>";

try {
    // Check if face_data column exists
    $result = $db->query("SHOW COLUMNS FROM users LIKE 'face_data'")->fetch();
    
    if ($result) {
        echo "<div class='alert alert-info'>✓ face_data column already exists</div>";
    } else {
        // Add face_data column
        $db->query("ALTER TABLE users ADD COLUMN face_data LONGBLOB DEFAULT NULL AFTER login_ip");
        echo "<div class='alert alert-success'>✓ face_data column added successfully</div>";
    }
    
    // Check if face_last_updated column exists
    $result = $db->query("SHOW COLUMNS FROM users LIKE 'face_last_updated'")->fetch();
    
    if ($result) {
        echo "<div class='alert alert-info'>✓ face_last_updated column already exists</div>";
    } else {
        // Add face_last_updated column
        $db->query("ALTER TABLE users ADD COLUMN face_last_updated TIMESTAMP NULL DEFAULT NULL AFTER face_data");
        echo "<div class='alert alert-success'>✓ face_last_updated column added successfully</div>";
    }
    
    // Verify columns
    echo "<h3>Current users table structure:</h3>";
    $columns = $db->query("SHOW COLUMNS FROM users")->fetchAll(PDO::FETCH_ASSOC);
    
    echo "<table border='1' cellpadding='10' style='margin-top:20px;'>";
    echo "<tr><th>Field</th><th>Type</th><th>Null</th><th>Key</th></tr>";
    foreach ($columns as $col) {
        echo "<tr>";
        echo "<td>" . htmlspecialchars($col['Field']) . "</td>";
        echo "<td>" . htmlspecialchars($col['Type']) . "</td>";
        echo "<td>" . htmlspecialchars($col['Null']) . "</td>";
        echo "<td>" . htmlspecialchars($col['Key']) . "</td>";
        echo "</tr>";
    }
    echo "</table>";
    
} catch (Exception $e) {
    echo "<div class='alert alert-danger'>Error: " . htmlspecialchars($e->getMessage()) . "</div>";
}

echo "<hr>";
echo "<p><a href='../admin/dashboard.php'>Back to Admin Dashboard</a></p>";
?>
