<?php
/**
 * Add login_device, login_ip and last_login_at columns to users table
 * Visit: http://localhost/extract/database/add_login_tracking.php
 */

require_once __DIR__ . '/../config/config.php';
require_once __DIR__ . '/../classes/Database.php';

$db = Database::getInstance();

echo "<style>body { font-family: Arial; margin: 20px; }</style>";
echo "<h2>🔧 Login Tracking Setup</h2>";

try {
    // Check if columns exist
    $columns = $db->query("SHOW COLUMNS FROM users")->fetchAll(PDO::FETCH_ASSOC);
    $columnNames = array_column($columns, 'Field');
    
    $added = [];
    
    if (!in_array('login_device', $columnNames)) {
        $db->query("ALTER TABLE users ADD COLUMN login_device VARCHAR(50) DEFAULT NULL AFTER updated_at");
        $added[] = "✓ Added login_device column";
    } else {
        $added[] = "✓ login_device column already exists";
    }
    
    if (!in_array('login_ip', $columnNames)) {
        $db->query("ALTER TABLE users ADD COLUMN login_ip VARCHAR(45) DEFAULT NULL AFTER login_device");
        $added[] = "✓ Added login_ip column";
    } else {
        $added[] = "✓ login_ip column already exists";
    }
    
    if (!in_array('last_login_at', $columnNames)) {
        $db->query("ALTER TABLE users ADD COLUMN last_login_at DATETIME DEFAULT NULL AFTER login_ip");
        $added[] = "✓ Added last_login_at column";
    } else {
        $added[] = "✓ last_login_at column already exists";
    }
    
    echo "<div style='background: #d4edda; border: 1px solid #c3e6cb; padding: 15px; border-radius: 5px; color: #155724;'>";
    echo "<h4>Migration Completed!</h4>";
    foreach ($added as $msg) {
        echo "<p>$msg</p>";
    }
    echo "<p><strong>Next Steps:</strong> Users will now have their device type and IP address tracked on login.</p>";
    echo "</div>";
    
} catch (Exception $e) {
    echo "<div style='background: #f8d7da; border: 1px solid #f5c6cb; padding: 15px; border-radius: 5px; color: #721c24;'>";
    echo "<h4>Error</h4>";
    echo "<p>" . $e->getMessage() . "</p>";
    echo "</div>";
}

