-- ============================================
-- OTP EMAIL SYSTEM - DATABASE SETUP
-- For: Razorhost (iplztpse_final database)
-- Created: 2025-11-22
-- ============================================

-- Step 1: Create email_otps table
-- Stores all OTP codes with expiry tracking
-- ============================================

CREATE TABLE IF NOT EXISTS email_otps (
    id INT AUTO_INCREMENT PRIMARY KEY,
    email VARCHAR(255) UNIQUE NOT NULL,
    otp VARCHAR(10) NOT NULL,
    attempts INT DEFAULT 0,
    created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
    expires_at TIMESTAMP NULL,
    INDEX idx_email (email),
    INDEX idx_expires (expires_at)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Step 2: Create admin_settings table
-- Stores configuration overrides from admin panel
-- ============================================

CREATE TABLE IF NOT EXISTS admin_settings (
    id INT AUTO_INCREMENT PRIMARY KEY,
    setting_key VARCHAR(255) UNIQUE NOT NULL,
    setting_value LONGTEXT,
    updated_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
    INDEX idx_key (setting_key)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Step 3: Insert default admin settings
-- ============================================

INSERT IGNORE INTO admin_settings (setting_key, setting_value) VALUES
('email_mode', 'php_mail'),
('smtp_host', 'smtp.gmail.com'),
('smtp_port', '587'),
('smtp_secure', 'tls'),
('smtp_username', 's26118152@gmail.com'),
('smtp_password', ''),
('from_email', 'noreply@simplechecks.xyz'),
('from_name', 'Advanced Mobile Info'),
('otp_expiry_minutes', '5'),
('otp_max_attempts', '5'),
('brevo_api_key', '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'),
('brevo_enabled', 'true');

-- Step 4: Verify tables exist
-- ============================================

SHOW TABLES LIKE 'email_otps';
SHOW TABLES LIKE 'admin_settings';

-- Step 5: Check table structure
-- ============================================

DESCRIBE email_otps;
DESCRIBE admin_settings;

-- Step 6: Verify data
-- ============================================

SELECT COUNT(*) as admin_settings_count FROM admin_settings;
SELECT * FROM admin_settings LIMIT 1;

-- ============================================
-- ✅ SETUP COMPLETE
-- ============================================
-- 
-- Tables created:
-- ✅ email_otps - Stores OTP codes (auto-delete after 5 min)
-- ✅ admin_settings - Stores configuration
--
-- Default settings inserted:
-- ✅ OTP expiry: 5 minutes
-- ✅ Max attempts: 5
-- ✅ Email mode: php_mail
-- ✅ Brevo API key: Configured
--
-- Next steps:
-- 1. Upload .env file to /public_html/extract/
-- 2. Upload classes/OTPManager.php
-- 3. Upload admin/dashboard.php
-- 4. Upload config/email_config.php
-- 5. Test at: https://simplechecks.xyz/extract/test_brevo_direct.php
--
-- ============================================
