<?php
session_start();
require_once 'config/config.php';
require_once 'classes/Database.php';
require_once 'classes/Auth.php';

$auth = new Auth(Database::getInstance());

if (!$auth->isLoggedIn()) {
    header('Location: login.php');
    exit();
}

$orderId = $_GET['order_id'] ?? null;

if (!$orderId || !isset($_SESSION['razorpay_order'])) {
    header('Location: user_subscriptions.php');
    exit();
}

$order = $_SESSION['razorpay_order'];
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Payment Processing</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <style>
        body {
            background: linear-gradient(135deg, #f5f7fa 0%, #c3cfe2 100%);
            min-height: 100vh;
            display: flex;
            align-items: center;
            justify-content: center;
        }
        
        .payment-container {
            background: white;
            border-radius: 12px;
            box-shadow: 0 10px 40px rgba(0,0,0,0.2);
            padding: 2rem;
            max-width: 500px;
            width: 100%;
        }
        
        .payment-header {
            text-align: center;
            margin-bottom: 2rem;
        }
        
        .payment-amount {
            font-size: 2.5rem;
            font-weight: 700;
            color: #007AFF;
            margin: 1rem 0;
        }
        
        .btn-pay {
            width: 100%;
            padding: 1rem;
            font-size: 1.1rem;
            font-weight: 600;
            background: #007AFF;
            border: none;
            border-radius: 8px;
            color: white;
            cursor: pointer;
            transition: all 0.3s;
        }
        
        .btn-pay:hover {
            background: #0051cc;
            box-shadow: 0 4px 12px rgba(0, 122, 255, 0.4);
        }
        
        .order-summary {
            background: #f9f9f9;
            padding: 1.5rem;
            border-radius: 8px;
            margin-bottom: 1.5rem;
        }
        
        .summary-item {
            display: flex;
            justify-content: space-between;
            padding: 0.5rem 0;
            border-bottom: 1px solid #e5e5ea;
        }
        
        .summary-item:last-child {
            border-bottom: none;
        }
        
        .summary-total {
            font-weight: 700;
            font-size: 1.1rem;
            padding-top: 0.5rem;
        }
    </style>
</head>
<body>
    <div class="payment-container">
        <div class="payment-header">
            <h2>💳 Complete Your Payment</h2>
            <p class="text-muted">Secure payment powered by Razorpay</p>
        </div>
        
        <div class="order-summary">
            <div class="summary-item">
                <span>Order ID:</span>
                <span class="font-monospace"><?php echo htmlspecialchars($orderId); ?></span>
            </div>
            <div class="summary-item">
                <span>Subscription ID:</span>
                <span class="font-monospace"><?php echo htmlspecialchars($order['subscription_id']); ?></span>
            </div>
            <div class="summary-item">
                <span>Plan:</span>
                <span>Plan #<?php echo htmlspecialchars($order['plan_id']); ?></span>
            </div>
            <div class="summary-item summary-total">
                <span>Amount Payable:</span>
                <span style="color: #007AFF;">₹<?php echo number_format($order['amount'], 2); ?></span>
            </div>
        </div>
        
        <form id="paymentForm">
            <button type="button" id="rzp-button" class="btn-pay">
                Pay ₹<?php echo number_format($order['amount'], 2); ?> Securely
            </button>
        </form>
        
        <p class="text-center text-muted mt-3 mb-0" style="font-size: 0.875rem;">
            You will be redirected after successful payment
        </p>
    </div>
    
    <!-- Razorpay Script -->
    <script src="https://checkout.razorpay.com/v1/checkout.js"></script>
    
    <script>
        document.getElementById('rzp-button').addEventListener('click', function(e) {
            e.preventDefault();
            
            const options = {
                key: '<?php echo htmlspecialchars(RAZORPAY_KEY_ID); ?>', // Your Razorpay Key ID
                amount: <?php echo $order['amount'] * 100; ?>, // Amount in paise
                currency: 'INR',
                name: 'Subscription Payment',
                description: 'Plan Subscription',
                order_id: '<?php echo htmlspecialchars($orderId); ?>', // Order ID created on the server
                handler: function(response) {
                    // Send verification to server
                    const formData = new FormData();
                    formData.append('action', 'verify_payment');
                    formData.append('razorpay_order_id', response.razorpay_order_id);
                    formData.append('razorpay_payment_id', response.razorpay_payment_id);
                    formData.append('razorpay_signature', response.razorpay_signature);
                    
                    fetch('api/razorpay_payment.php', {
                        method: 'POST',
                        body: formData
                    })
                    .then(res => res.json())
                    .then(data => {
                        if (data.status) {
                            alert('✅ Payment successful!');
                            window.location.href = 'user_subscriptions.php?success=1';
                        } else {
                            alert('❌ ' + data.message);
                            window.location.href = 'user_subscriptions.php?error=1';
                        }
                    })
                    .catch(err => {
                        alert('❌ Error verifying payment');
                        console.error(err);
                    });
                },
                prefill: {
                    email: '<?php echo htmlspecialchars($_SESSION['email'] ?? ''); ?>',
                    contact: ''
                },
                theme: {
                    color: '#007AFF'
                },
                modal: {
                    ondismiss: function() {
                        console.log('Payment cancelled');
                        window.location.href = 'user_subscriptions.php';
                    }
                }
            };
            
            const rzp = new Razorpay(options);
            rzp.open();
        });
    </script>
</body>
</html>
