<?php
$search_query = '';
$user_results = [];
$search_history = [];

// Search logic
if (isset($_GET['search']) || isset($_POST['search'])) {
    $search_query = trim($_GET['search'] ?? $_POST['search'] ?? '');
    
    if (strlen($search_query) >= 2) {
        $query = "SELECT id, custom_code, name, email, role, is_active, password, 
                         last_device_type, last_device_ip FROM users 
                  WHERE name LIKE :search 
                  OR email LIKE :search 
                  OR custom_code LIKE :search
                  ORDER BY id DESC";
        
        $user_results = $db->fetchAll($query, [':search' => '%' . $search_query . '%']);
    }
}

// Get search history from search_logs table (if exists)
$search_logs_exist = $db->fetch("SELECT COUNT(*) as cnt FROM information_schema.TABLES 
                                  WHERE TABLE_SCHEMA = DATABASE() 
                                  AND TABLE_NAME = 'search_logs'");

if ($search_logs_exist && $search_logs_exist['cnt'] > 0) {
    $history_query = "SELECT user_id, search_query, results_count, created_at FROM search_logs 
                      ORDER BY created_at DESC LIMIT 50";
    $search_history = $db->fetchAll($history_query);
}
?>

<style>
.search-container {
    background: linear-gradient(135deg, #007aff 0%, #0051e8 100%);
    padding: 30px;
    border-radius: 16px;
    margin-bottom: 30px;
    color: white;
    box-shadow: 0 4px 18px rgba(0,0,0,0.1);
}

.search-container h3 {
    margin-bottom: 20px;
    font-weight: 700;
    font-size: 24px;
}

.search-box {
    display: flex;
    gap: 10px;
}

.search-box input {
    flex: 1;
    padding: 12px 15px;
    border: none;
    border-radius: 10px;
    font-size: 14px;
    background: rgba(255,255,255,0.95);
}

.search-box input:focus {
    outline: none;
    background: white;
    box-shadow: 0 0 0 3px rgba(0,122,255,0.3);
}

.search-box button {
    padding: 12px 30px;
    background: white;
    color: #007aff;
    border: none;
    border-radius: 10px;
    font-weight: 600;
    cursor: pointer;
    transition: 0.3s;
}

.search-box button:hover {
    transform: translateY(-2px);
    box-shadow: 0 5px 15px rgba(0,0,0,0.2);
}

.results-section h4 {
    font-weight: 700;
    color: var(--text);
    margin-bottom: 20px;
}

.user-card {
    background: white;
    border: none;
    border-radius: 12px;
    padding: 20px;
    margin-bottom: 15px;
    box-shadow: 0 2px 10px rgba(0,0,0,0.05);
    transition: 0.3s;
}

.user-card:hover {
    box-shadow: 0 8px 20px rgba(0,0,0,0.1);
    transform: translateY(-2px);
}

.user-header {
    display: flex;
    justify-content: space-between;
    align-items: start;
    margin-bottom: 15px;
    border-bottom: 1px solid #f0f0f0;
    padding-bottom: 12px;
}

.user-name {
    font-size: 18px;
    font-weight: 600;
    color: #1c1c1e;
}

.user-id {
    font-size: 12px;
    color: #999;
    margin-top: 4px;
}

.badge-group {
    display: flex;
    gap: 8px;
    flex-wrap: wrap;
}

.user-badge {
    display: inline-block;
    padding: 6px 12px;
    border-radius: 20px;
    font-size: 12px;
    font-weight: 600;
}

.badge-admin {
    background: #ff3b30;
    color: white;
}

.badge-user {
    background: #34c759;
    color: white;
}

.badge-active {
    background: #007aff;
    color: white;
}

.badge-inactive {
    background: #d0d0d0;
    color: #666;
}

.user-info {
    display: grid;
    grid-template-columns: repeat(auto-fit, minmax(180px, 1fr));
    gap: 12px;
    margin-top: 15px;
}

.info-item {
    background: #f8f9fa;
    padding: 12px;
    border-radius: 8px;
    border-left: 3px solid #007aff;
}

.info-label {
    font-size: 11px;
    color: #999;
    font-weight: 600;
    text-transform: uppercase;
    letter-spacing: 0.5px;
}

.info-value {
    font-size: 14px;
    color: #1c1c1e;
    margin-top: 6px;
    word-break: break-all;
    font-weight: 500;
}

.info-value code {
    background: white;
    padding: 2px 6px;
    border-radius: 4px;
    font-size: 12px;
}

.search-history-item {
    background: white;
    border-left: 3px solid #007aff;
    padding: 12px;
    margin-bottom: 8px;
    border-radius: 6px;
    font-size: 13px;
}

.search-history-item strong {
    color: #1c1c1e;
}

.search-history-item small {
    color: #999;
}

.no-results {
    text-align: center;
    padding: 60px 20px;
    background: white;
    border-radius: 12px;
    color: #999;
}

.no-results h5 {
    font-weight: 600;
    color: #666;
    margin-bottom: 10px;
}

.no-results p {
    margin: 0;
    font-size: 14px;
}
</style>

<div class="search-container">
    <h3>🔍 Search Users</h3>
    <form method="POST" class="search-box">
        <input type="text" name="search" placeholder="Search by name, email, or custom code..." 
               value="<?= htmlspecialchars($search_query) ?>" required>
        <button type="submit">Search</button>
    </form>
</div>

<!-- RESULTS -->
<?php if ((isset($_GET['search']) || isset($_POST['search'])) && !empty($search_query)): ?>
    <div class="results-section">
        <h4>📋 Search Results 
            <?php if (count($user_results) > 0): ?>
                <span class="badge bg-info"><?= count($user_results) ?> found</span>
            <?php endif; ?>
        </h4>

        <?php if (count($user_results) > 0): ?>
            <?php foreach ($user_results as $user): ?>
                <div class="user-card">
                    <div class="user-header">
                        <div>
                            <div class="user-name"><?= htmlspecialchars($user['name']) ?></div>
                            <div class="user-id">ID: #<?= (int)$user['id'] ?> | 🌐 IP: <?= htmlspecialchars($user['last_device_ip'] ?? 'N/A') ?></div>
                        </div>
                        <div class="badge-group">
                            <?php if ($user['role'] === 'admin'): ?>
                                <span class="user-badge badge-admin">Admin</span>
                            <?php else: ?>
                                <span class="user-badge badge-user">User</span>
                            <?php endif; ?>
                            <?php if ($user['is_active']): ?>
                                <span class="user-badge badge-active">Active</span>
                            <?php else: ?>
                                <span class="user-badge badge-inactive">Inactive</span>
                            <?php endif; ?>
                        </div>
                    </div>

                    <?php 
                        $wallet = $db->fetch("SELECT balance FROM wallets WHERE user_id = ?", [$user['id']]);
                    ?>

                    <div class="user-info">
                        <div class="info-item">
                            <div class="info-label">📧 Email</div>
                            <div class="info-value"><?= htmlspecialchars($user['email']) ?></div>
                        </div>

                        <div class="info-item">
                            <div class="info-label">🔐 Custom Code</div>
                            <div class="info-value">
                                <code><?= htmlspecialchars($user['custom_code']) ?></code>
                            </div>
                        </div>

                        <div class="info-item">
                            <div class="info-label">💰 Wallet Balance</div>
                            <div class="info-value">
                                ₹<?= $wallet ? number_format($wallet['balance'], 2) : '0.00' ?>
                            </div>
                        </div>

                        <div class="info-item">
                            <div class="info-label">📱 Device Type</div>
                            <div class="info-value">
                                <?= htmlspecialchars($user['last_device_type'] ?? 'Unknown') ?>
                            </div>
                        </div>

                        <div class="info-item">
                            <div class="info-label">🌐 Last IP</div>
                            <div class="info-value">
                                <code><?= htmlspecialchars($user['last_device_ip'] ?? 'N/A') ?></code>
                            </div>
                        </div>

                        <div class="info-item">
                            <div class="info-label">🔑 Password Hash</div>
                            <div class="info-value" style="display: flex; align-items: center; gap: 8px;">
                                <code id="pwd-<?= (int)$user['id'] ?>" style="flex: 1; font-size: 11px;">••••••••</code>
                                <button 
                                    type="button" 
                                    data-pwd="<?= htmlspecialchars(base64_encode($user['password'] ?? '')) ?>" 
                                    onclick="togglePassword(<?= (int)$user['id'] ?>, this)" 
                                    style="background: #007aff; color: white; border: none; padding: 4px 8px; border-radius: 4px; cursor: pointer; font-size: 12px;">
                                    👁️ Show
                                </button>
                            </div>
                        </div>
                    </div> <!-- .user-info -->
                </div> <!-- .user-card -->
            <?php endforeach; ?>
        <?php else: ?>
            <div class="no-results">
                <h5>❌ No users found</h5>
                <p>Try searching with different keywords</p>
            </div>
        <?php endif; ?>
    </div>
<?php else: ?>
    <div class="no-results">
        <h5>🔍 Start searching</h5>
        <p>Enter a name, email, or custom code above to find users and view their details</p>
    </div>
<?php endif; ?>

<script>
function togglePassword(userId, button) {
    const passwordDisplay = document.getElementById('pwd-' + userId);
    const encodedPassword = button.getAttribute('data-pwd') || '';
    const password = encodedPassword ? atob(encodedPassword) : '';

    if (passwordDisplay.textContent === '••••••••') {
        // Display hash directly without hiding
        passwordDisplay.textContent = password || 'N/A';
        passwordDisplay.style.wordBreak = 'break-all';
        passwordDisplay.style.fontSize = '11px';
        button.textContent = '🔒 Hidden';
        button.disabled = true;
        button.style.opacity = '0.5';
        button.style.cursor = 'not-allowed';
    } else {
        passwordDisplay.textContent = '••••••••';
        passwordDisplay.style.wordBreak = 'normal';
        button.textContent = '👁️ Show';
        button.disabled = false;
        button.style.opacity = '1';
        button.style.cursor = 'pointer';
    }
}
</script>

