<?php
require_once 'config/config.php';
require_once 'classes/Database.php';

$db = Database::getInstance();

echo "<h1>📊 Database Analysis & Real Search Data Migration</h1>";

// Get all tables
$tables = $db->fetchAll("SELECT TABLE_NAME FROM information_schema.TABLES WHERE TABLE_SCHEMA = DATABASE()");
$table_names = array_column($tables, 'TABLE_NAME');

echo "<h2>Available Tables:</h2>";
echo "<ul>";
foreach ($table_names as $table) {
    echo "<li>$table</li>";
}
echo "</ul>";

// Check mobile_info_system or similar tables with real data
echo "<h2>Looking for Real Search Data...</h2>";

// Check if there's a searches table with real data
$searches_count = $db->fetch("SELECT COUNT(*) as cnt FROM searches WHERE user_id IS NOT NULL");
echo "<p><strong>Total searches in database:</strong> " . $searches_count['cnt'] . "</p>";

if ($searches_count['cnt'] > 0) {
    echo "<h3>Sample Searches from Database:</h3>";
    $sample = $db->fetchAll("SELECT * FROM searches ORDER BY created_at DESC LIMIT 5");
    echo "<pre>";
    print_r($sample);
    echo "</pre>";
}

// Check user_searches or similar
$user_searches_tables = array_filter($table_names, function($t) {
    return stripos($t, 'search') !== false || stripos($t, 'user_search') !== false;
});

if (!empty($user_searches_tables)) {
    echo "<h2>Search-Related Tables Found:</h2>";
    foreach ($user_searches_tables as $table) {
        $count = $db->fetch("SELECT COUNT(*) as cnt FROM `$table`");
        echo "<p><strong>$table:</strong> " . $count['cnt'] . " records</p>";
        
        if ($count['cnt'] > 0) {
            $sample = $db->fetchAll("SELECT * FROM `$table` LIMIT 3");
            echo "<pre>";
            print_r($sample);
            echo "</pre>";
        }
    }
}

// Check mobile_info_results
if (in_array('mobile_info_results', $table_names)) {
    $mobile_count = $db->fetch("SELECT COUNT(*) as cnt FROM mobile_info_results");
    echo "<h2>Mobile Info Results: " . $mobile_count['cnt'] . " records</h2>";
    
    if ($mobile_count['cnt'] > 0) {
        $sample = $db->fetchAll("SELECT * FROM mobile_info_results LIMIT 5");
        echo "<pre>";
        print_r($sample);
        echo "</pre>";
    }
}

// Get specific user 83 searches
echo "<h2>User #83 (Sandesh) Searches:</h2>";
$user_83_searches = $db->fetchAll("SELECT * FROM searches WHERE user_id = 83");
echo "<p>Count: " . count($user_83_searches) . "</p>";
echo "<pre>";
print_r($user_83_searches);
echo "</pre>";

// Query to show users with no searches
echo "<h2>Users with no searches:</h2>";
$no_searches = $db->fetchAll("
    SELECT u.id, u.name, u.email, COUNT(s.id) as search_count 
    FROM users u 
    LEFT JOIN searches s ON u.id = s.user_id 
    GROUP BY u.id 
    HAVING search_count = 0 
    LIMIT 10
");
echo "<pre>";
print_r($no_searches);
echo "</pre>";

?>
